/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.codec;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.gimmick.codec.AspectSetCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public record HeldItemFormChange(List<String> pokemons, AspectSetCodec aspect_conditions, Optional<ResourceLocation> effect, boolean tradable) {
    public static final Codec<HeldItemFormChange> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("pokemons").forGetter(HeldItemFormChange::pokemons), (App)AspectSetCodec.CODEC.fieldOf("aspect_conditions").forGetter(HeldItemFormChange::aspect_conditions), (App)ResourceLocation.CODEC.optionalFieldOf("effect").forGetter(HeldItemFormChange::effect), (App)Codec.BOOL.fieldOf("tradable").forGetter(HeldItemFormChange::tradable)).apply((Applicative)instance, HeldItemFormChange::new));

    public void apply(Pokemon pokemon) {
        if (this.pokemons.contains(pokemon.getSpecies().getName()) && this.aspect_conditions().validate_apply(pokemon)) {
            Effect.getEffect(this.effect.get()).applyEffects(pokemon, this.aspect_conditions.apply_aspects(), null);
            if (!this.tradable) {
                pokemon.setTradeable(false);
            }
        }
    }

    public void revert(Pokemon pokemon) {
        if (this.pokemons.contains(pokemon.getSpecies().getName()) && this.aspect_conditions().validate_revert(pokemon)) {
            Effect.getEffect(this.effect.get()).revertEffects(pokemon, this.aspect_conditions.revert_aspects(), null);
            if (!this.tradable) {
                pokemon.setTradeable(true);
            }
        }
    }
}

