/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.mixin;

import com.cobblemon.mod.common.client.entity.PokemonClientDelegate;
import com.cobblemon.mod.common.client.render.MatrixWrapper;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.RenderContext;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.VaryingModelRepository;
import com.cobblemon.mod.common.client.render.pokemon.PokemonRenderer;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.block.block_entity.renderer.state.TeraHatState;
import com.github.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Unit;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PokemonRenderer.class})
public class PokemonRendererMixin {
    @Unique
    private final RenderContext mega_showdown$context = new RenderContext();
    @Unique
    private final ResourceLocation mega_showdown$poserId = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"tera_hat");
    @Unique
    private final TeraHatState mega_showdown$teraHatState = new TeraHatState();
    @Unique
    private final Set<String> mega_showdown$aspects = new HashSet<String>();

    @Inject(method={"<init>(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V"}, at={@At(value="RETURN")})
    public void init(EntityRendererProvider.Context context, CallbackInfo ci) {
        this.mega_showdown$context.put(RenderContext.Companion.getRENDER_STATE(), (Object)RenderContext.RenderState.WORLD);
        this.mega_showdown$context.put(RenderContext.Companion.getDO_QUIRKS(), (Object)true);
    }

    @Inject(method={"render*"}, at={@At(value="TAIL")})
    public void render(PokemonEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        PokemonClientDelegate clientDelegate = (PokemonClientDelegate)entity.getDelegate();
        Pokemon pokemon = entity.getPokemon();
        Optional<String> aspect = pokemon.getAspects().stream().filter(a -> a.startsWith("msd:tera_")).findFirst();
        if (aspect.isPresent() && MegaShowdownConfig.teraHats) {
            if (pokemon.getSpecies().getName().equals("Terapagos")) {
                return;
            }
            Map locatorStates = clientDelegate.getLocatorStates();
            MatrixWrapper headLocator = (MatrixWrapper)locatorStates.get("head");
            if (headLocator == null) {
                return;
            }
            poseStack.pushPose();
            poseStack.mulPose(headLocator.getMatrix());
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.translate(0.08, 0.0, 0.0);
            this.mega_showdown$aspects.clear();
            this.mega_showdown$aspects.add(aspect.get());
            this.mega_showdown$teraHatState.setCurrentAspects(this.mega_showdown$aspects);
            this.mega_showdown$teraHatState.updatePartialTicks(partialTicks);
            PosableModel model = VaryingModelRepository.INSTANCE.getPoser(this.mega_showdown$poserId, (PosableState)this.mega_showdown$teraHatState);
            ResourceLocation texture = VaryingModelRepository.INSTANCE.getTexture(this.mega_showdown$poserId, (PosableState)this.mega_showdown$teraHatState);
            model.context = this.mega_showdown$context;
            model.setBufferProvider(buffer);
            this.mega_showdown$teraHatState.setCurrentModel(model);
            this.mega_showdown$context.put(RenderContext.Companion.getASPECTS(), this.mega_showdown$aspects);
            this.mega_showdown$context.put(RenderContext.Companion.getTEXTURE(), (Object)texture);
            this.mega_showdown$context.put(RenderContext.Companion.getSPECIES(), (Object)this.mega_showdown$poserId);
            this.mega_showdown$context.put(RenderContext.Companion.getPOSABLE_STATE(), (Object)this.mega_showdown$teraHatState);
            model.applyAnimations(null, (PosableState)this.mega_showdown$teraHatState, 0.0f, 0.0f, 0.0f, 0.0f, this.mega_showdown$teraHatState.getAnimationSeconds() * 20.0f);
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)texture));
            model.render(this.mega_showdown$context, poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
            model.withLayerContext(buffer, (PosableState)this.mega_showdown$teraHatState, VaryingModelRepository.INSTANCE.getLayers(this.mega_showdown$poserId, (PosableState)this.mega_showdown$teraHatState), () -> {
                model.render(this.mega_showdown$context, poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
                return Unit.INSTANCE;
            });
            model.setDefault();
            poseStack.popPose();
        }
    }
}

