/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.lang.Nullable;

public interface SingleResultCallback<T> {
    public void onResult(@Nullable T var1, @Nullable Throwable var2);

    default public AsyncCompletionHandler<T> asHandler() {
        return new AsyncCompletionHandler<T>(){

            @Override
            public void completed(@Nullable T result) {
                SingleResultCallback.this.onResult(result, null);
            }

            @Override
            public void failed(Throwable t2) {
                SingleResultCallback.this.completeExceptionally(t2);
            }
        };
    }

    default public void complete(SingleResultCallback<Void> callback) {
        Assertions.assertTrue(callback == this);
        this.onResult(null, null);
    }

    default public void complete(@Nullable T result) {
        this.onResult(result, null);
    }

    default public void completeExceptionally(Throwable t2) {
        this.onResult(null, Assertions.assertNotNull(t2));
    }
}

