/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.function;

import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.lang.Nullable;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;

@NotThreadSafe
public final class RetryingAsyncCallbackSupplier<R>
implements AsyncCallbackSupplier<R> {
    private final RetryState state;
    private final BiPredicate<RetryState, Throwable> retryPredicate;
    private final BinaryOperator<Throwable> onAttemptFailureOperator;
    private final AsyncCallbackSupplier<R> asyncFunction;

    public RetryingAsyncCallbackSupplier(RetryState state, BinaryOperator<Throwable> onAttemptFailureOperator, BiPredicate<RetryState, Throwable> retryPredicate, AsyncCallbackSupplier<R> asyncFunction) {
        this.state = state;
        this.retryPredicate = retryPredicate;
        this.onAttemptFailureOperator = onAttemptFailureOperator;
        this.asyncFunction = asyncFunction;
    }

    public RetryingAsyncCallbackSupplier(RetryState state, BiPredicate<RetryState, Throwable> retryPredicate, AsyncCallbackSupplier<R> asyncFunction) {
        this(state, (previouslyChosenFailure, lastAttemptFailure) -> lastAttemptFailure, retryPredicate, asyncFunction);
    }

    @Override
    public void get(SingleResultCallback<R> callback) {
        this.asyncFunction.get(new RetryingCallback(callback));
    }

    @NotThreadSafe
    private class RetryingCallback
    implements SingleResultCallback<R> {
        private final SingleResultCallback<R> wrapped;

        RetryingCallback(SingleResultCallback<R> callback) {
            this.wrapped = callback;
        }

        @Override
        public void onResult(@Nullable R result, @Nullable Throwable t2) {
            if (t2 != null) {
                try {
                    RetryingAsyncCallbackSupplier.this.state.advanceOrThrow(t2, (BinaryOperator<Throwable>)RetryingAsyncCallbackSupplier.this.onAttemptFailureOperator, (BiPredicate<RetryState, Throwable>)RetryingAsyncCallbackSupplier.this.retryPredicate);
                }
                catch (Throwable failedResult) {
                    this.wrapped.onResult(null, failedResult);
                    return;
                }
                RetryingAsyncCallbackSupplier.this.asyncFunction.get(this);
            } else {
                this.wrapped.onResult(result, null);
            }
        }
    }
}

