/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoInternalException;
import com.mongodb.internal.connection.ResponseBuffers;
import org.bson.BsonBinaryReader;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.io.ByteBufferBsonInput;

public class ReplyMessage<T> {
    private final T document;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplyMessage(ResponseBuffers responseBuffers, Decoder<T> decoder, long requestId) {
        if (requestId != (long)responseBuffers.getReplyHeader().getResponseTo()) {
            throw new MongoInternalException(String.format("The responseTo (%d) in the response does not match the requestId (%d) in the request", responseBuffers.getReplyHeader().getResponseTo(), requestId));
        }
        try (ByteBufferBsonInput bsonInput = new ByteBufferBsonInput(responseBuffers.getBodyByteBuffer().duplicate());
             BsonBinaryReader reader = new BsonBinaryReader(bsonInput);){
            this.document = decoder.decode(reader, DecoderContext.builder().build());
        }
        finally {
            responseBuffers.reset();
        }
    }

    public T getDocument() {
        return this.document;
    }
}

