/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.harfull.nexuseco.command.BalTopCommand;
import xyz.harfull.nexuseco.command.BalanceCommand;
import xyz.harfull.nexuseco.command.EconomyCommand;
import xyz.harfull.nexuseco.command.HistoryCommand;
import xyz.harfull.nexuseco.command.NexusEcoCommand;
import xyz.harfull.nexuseco.command.PayCommand;
import xyz.harfull.nexuseco.command.PayToggle;
import xyz.harfull.nexuseco.command.ProfileCommand;
import xyz.harfull.nexuseco.economy.EconomyManager;
import xyz.harfull.nexuseco.event.JoinListener;
import xyz.harfull.nexuseco.gui.BaltopGUI;
import xyz.harfull.nexuseco.gui.HistoryGUI;
import xyz.harfull.nexuseco.gui.ProfileGUI;
import xyz.harfull.nexuseco.integration.PAPI;
import xyz.harfull.nexuseco.integration.Vault;
import xyz.harfull.nexuseco.migration.MigrationManager;
import xyz.harfull.nexuseco.util.MessageManager;
import xyz.harfull.nexuseco.util.NumberFormatting;
import xyz.harfull.nexuseco.util.PlayerUtils;
import xyz.harfull.nexuseco.util.TaskScheduler;

public final class NexusEco
extends JavaPlugin {
    private EconomyManager economyManager;
    private MessageManager messageManager;
    private TaskScheduler taskScheduler;
    private MigrationManager migrationManager;
    private BalanceCommand balanceCommand;
    private EconomyCommand economyCommand;
    private PayCommand payCommand;
    private HistoryCommand historyCommand;
    private BalTopCommand balTopCommand;
    private ProfileCommand profileCommand;
    private NexusEcoCommand nexusEcoCommand;
    private PayToggle payToggleCommand;
    private HistoryGUI historyGUI;
    private BaltopGUI baltopGUI;
    private ProfileGUI profileGUI;
    private File historyUIFile;
    private File baltopUIFile;
    private File profileUIFile;
    private boolean isFolia;

    public void onLoad() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            this.isFolia = true;
            this.getLogger().info("Folia environment detected.");
        }
        catch (ClassNotFoundException e) {
            this.isFolia = false;
            this.getLogger().info("Non-Folia (Paper/Spigot) environment detected.");
        }
    }

    public void onEnable() {
        this.generateFiles();
        this.taskScheduler = new TaskScheduler((Plugin)this, this.isFolia);
        PlayerUtils.init(this);
        this.economyManager = new EconomyManager(this);
        NumberFormatting.loadConfig(this);
        this.registerGUIs();
        this.registerClasses();
        this.registerHooks();
        this.registerCommands();
        this.registerEvents();
    }

    public void onDisable() {
        if (this.economyManager != null) {
            this.economyManager.close();
        }
    }

    public void generateFiles() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (!new File(this.getDataFolder(), "database.yml").exists()) {
            this.saveResource("database.yml", false);
        }
        if (!new File(this.getDataFolder(), "messages.yml").exists()) {
            this.saveResource("messages.yml", false);
        }
        if (!new File(this.getDataFolder(), "guis/historyui.yml").exists()) {
            this.saveResource("guis/historyui.yml", false);
        }
        if (!new File(this.getDataFolder(), "guis/baltopui.yml").exists()) {
            this.saveResource("guis/baltopui.yml", false);
        }
        if (!new File(this.getDataFolder(), "guis/profileui.yml").exists()) {
            this.saveResource("guis/profileui.yml", false);
        }
        this.historyUIFile = new File(this.getDataFolder(), "guis/historyui.yml");
        this.baltopUIFile = new File(this.getDataFolder(), "guis/baltopui.yml");
        this.profileUIFile = new File(this.getDataFolder(), "guis/profileui.yml");
        this.saveDefaultConfig();
        this.reloadConfig();
        this.reloadFile(this.historyUIFile);
        this.reloadFile(this.baltopUIFile);
        this.reloadFile(this.profileUIFile);
    }

    private void reloadFile(File file) {
        try {
            YamlConfiguration.loadConfiguration((File)file);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.getLogger().severe("Error reloading " + file.getName() + ":\n" + String.valueOf(sw));
        }
    }

    private void registerGUIs() {
        if (this.historyUIFile != null) {
            this.historyGUI = new HistoryGUI(this, this.economyManager, this.historyUIFile);
        }
        if (this.profileUIFile != null) {
            this.profileGUI = new ProfileGUI(this, this.economyManager, this.profileUIFile);
        }
        if (this.baltopUIFile != null && this.profileGUI != null) {
            this.baltopGUI = new BaltopGUI(this, this.economyManager, this.baltopUIFile, this.profileGUI);
        }
    }

    private void registerClasses() {
        this.messageManager = new MessageManager(this);
        this.migrationManager = new MigrationManager(this);
        this.balanceCommand = new BalanceCommand(this, this.economyManager, this.messageManager);
        this.economyCommand = new EconomyCommand(this, this.economyManager, this.messageManager);
        this.payCommand = new PayCommand(this, this.economyManager, this.messageManager);
        this.historyCommand = new HistoryCommand(this, this.historyGUI, this.messageManager);
        this.balTopCommand = new BalTopCommand(this, this.baltopGUI, this.messageManager);
        this.profileCommand = new ProfileCommand(this, this.profileGUI, this.messageManager);
        this.nexusEcoCommand = new NexusEcoCommand(this, this.messageManager);
        this.payToggleCommand = new PayToggle(this);
    }

    private void registerHooks() {
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PAPI(this.economyManager).register();
            this.getLogger().info("PlaceholderAPI successfully hooked!");
        }
        if (this.getServer().getPluginManager().isPluginEnabled("Vault")) {
            Vault vault = new Vault(this, this.economyManager);
            this.getServer().getServicesManager().register(Economy.class, (Object)vault, (Plugin)this, ServicePriority.Normal);
            this.getLogger().info("Vault successfully hooked!");
        } else {
            this.getLogger().severe("Vault not found! Please install Vault to use this plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void registerCommands() {
        this.registerCommand("balance", this.balanceCommand);
        this.registerCommand("economy", this.economyCommand);
        this.registerCommand("pay", this.payCommand);
        this.registerCommand("history", this.historyCommand);
        this.registerCommand("baltop", this.balTopCommand);
        this.registerCommand("profile", this.profileCommand);
        this.registerCommand("nexuseco", this.nexusEcoCommand);
        this.registerCommand("paytoggle", this.payToggleCommand);
    }

    private void registerCommand(String name, Object executor) {
        PluginCommand command = this.getCommand(name);
        if (command != null) {
            command.setExecutor((CommandExecutor)executor);
            command.setTabCompleter((TabCompleter)executor);
        }
    }

    private void registerEvents() {
        this.registerListener(new JoinListener(this, this.economyManager));
    }

    private void registerListener(Object listener) {
        this.getServer().getPluginManager().registerEvents((Listener)listener, (Plugin)this);
    }

    public HistoryGUI getHistoryGUI() {
        return this.historyGUI;
    }

    public ProfileGUI getProfileGUI() {
        return this.profileGUI;
    }

    public BaltopGUI getBaltopGUI() {
        return this.baltopGUI;
    }

    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public MigrationManager getMigrationManager() {
        return this.migrationManager;
    }

    public boolean isFolia() {
        return this.isFolia;
    }
}

