/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.command;

import java.util.HashMap;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.harfull.nexuseco.NexusEco;
import xyz.harfull.nexuseco.gui.BaltopGUI;
import xyz.harfull.nexuseco.util.MessageManager;
import xyz.harfull.nexuseco.util.TaskScheduler;

public class BalTopCommand
implements CommandExecutor,
TabExecutor {
    private final BaltopGUI baltopGUI;
    private final MessageManager messageManager;
    private final String permission;
    private final boolean enabled;
    private final TaskScheduler taskScheduler;
    private final NexusEco plugin;

    public BalTopCommand(JavaPlugin plugin, BaltopGUI baltopGUI, MessageManager messageManager) {
        this.plugin = (NexusEco)plugin;
        this.baltopGUI = baltopGUI;
        this.messageManager = messageManager;
        this.taskScheduler = this.plugin.getTaskScheduler();
        this.permission = plugin.getConfig().getString("commands.baltop.permission", "nexuseco.baltop");
        this.enabled = plugin.getConfig().getBoolean("commands.baltop.enabled", true);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.enabled) {
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(MessageManager.translateColors("&cThis command can only be used by players."));
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(this.permission)) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(player, "general.NO_PERMISSION", placeholders);
            this.messageManager.sendActionBar(player, "general.NO_PERMISSION_ACTION_BAR", placeholders);
            return true;
        }
        this.taskScheduler.runTaskAsync(() -> this.plugin.getEconomyManager().getAllBalances());
        int page = 1;
        if (args.length > 0) {
            try {
                page = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                this.messageManager.sendMessage(player, "baltop.INVALID_PAGE", placeholders);
                this.messageManager.sendActionBar(player, "baltop.INVALID_PAGE_ACTION_BAR", placeholders);
                return true;
            }
        }
        int finalPage = page;
        this.taskScheduler.runEntityTask((Entity)player, p -> this.baltopGUI.open(player, finalPage));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        Player player;
        if (!(this.enabled && sender instanceof Player && (player = (Player)sender).hasPermission(this.permission))) {
            return null;
        }
        if (args.length == 1) {
            return List.of("1", "2", "3", "4", "5");
        }
        return null;
    }
}

