/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.command;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.harfull.nexuseco.NexusEco;
import xyz.harfull.nexuseco.economy.EconomyManager;
import xyz.harfull.nexuseco.util.MessageManager;
import xyz.harfull.nexuseco.util.PlayerUtils;
import xyz.harfull.nexuseco.util.TaskScheduler;

public class BalanceCommand
implements CommandExecutor,
TabExecutor {
    private final EconomyManager economyManager;
    private final MessageManager messageManager;
    private final String permission;
    private final boolean enabled;
    private final TaskScheduler taskScheduler;
    private final NexusEco plugin;

    public BalanceCommand(JavaPlugin plugin, EconomyManager economyManager, MessageManager messageManager) {
        this.plugin = (NexusEco)plugin;
        this.economyManager = economyManager;
        this.messageManager = messageManager;
        this.taskScheduler = this.plugin.getTaskScheduler();
        this.permission = plugin.getConfig().getString("commands.balance.permission", "nexuseco.balance");
        this.enabled = plugin.getConfig().getBoolean("commands.balance.enabled", true);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s2, @NotNull String[] strings) {
        if (!this.enabled) {
            return false;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!player.hasPermission(this.permission)) {
                this.messageManager.sendMessage(player, "general.NO_PERMISSION", new HashMap<String, String>());
                this.messageManager.sendActionBar(player, "general.NO_PERMISSION_ACTION_BAR", new HashMap<String, String>());
                return true;
            }
            if (strings.length == 0) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("balance", this.economyManager.getBalanceFormatted(player.getUniqueId()));
                this.messageManager.sendMessage(player, "balance.CHECK", placeholders);
                this.messageManager.sendActionBar(player, "balance.CHECK_ACTION_BAR", placeholders);
                return true;
            }
            if (strings.length == 1) {
                CompletableFuture<OfflinePlayer> future = PlayerUtils.findPlayerAsync(strings[0]);
                Player cachedTarget = Bukkit.getPlayerExact((String)strings[0]);
                if (cachedTarget != null && cachedTarget.isOnline()) {
                    this.handleBalanceCheck(player, (OfflinePlayer)cachedTarget);
                    return true;
                }
                future.thenAccept(target -> {
                    if (target != null) {
                        this.handleBalanceCheck(player, (OfflinePlayer)target);
                    } else {
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("player", strings[0]);
                        this.messageManager.sendMessage(player, "player.NOT_FOUND", placeholders);
                        this.messageManager.sendActionBar(player, "player.NOT_FOUND_ACTION_BAR", placeholders);
                    }
                });
                return true;
            }
            return false;
        }
        sender.sendMessage(MessageManager.translateColors("&cThis command can only be used by players."));
        return false;
    }

    private void handleBalanceCheck(Player player, OfflinePlayer target) {
        if (target.getUniqueId().equals(player.getUniqueId())) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("balance", this.economyManager.getBalanceFormatted(player.getUniqueId()));
            this.messageManager.sendMessage(player, "balance.CHECK", placeholders);
            this.messageManager.sendActionBar(player, "balance.CHECK_ACTION_BAR", placeholders);
            return;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", target.getName());
        placeholders.put("balance", this.economyManager.getBalanceFormatted(target.getUniqueId()));
        this.messageManager.sendMessage(player, "balance.CHECK_OTHER", placeholders);
        this.messageManager.sendActionBar(player, "balance.CHECK_OTHER_ACTION_BAR", placeholders);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s2, @NotNull String[] strings) {
        Player player;
        if (!(this.enabled && commandSender instanceof Player && (player = (Player)commandSender).hasPermission(this.permission))) {
            return null;
        }
        if (strings.length == 1) {
            return Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).toList();
        }
        return null;
    }
}

