/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.command;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.harfull.nexuseco.NexusEco;
import xyz.harfull.nexuseco.economy.EconomyManager;
import xyz.harfull.nexuseco.model.TransactionType;
import xyz.harfull.nexuseco.util.MessageManager;
import xyz.harfull.nexuseco.util.NumberFormatting;

public class EconomyCommand
implements CommandExecutor,
TabExecutor {
    private final EconomyManager economyManager;
    private final MessageManager messageManager;
    private final String permission;
    private final boolean enabled;
    private final NexusEco plugin;

    public EconomyCommand(JavaPlugin plugin, EconomyManager economyManager, MessageManager messageManager) {
        this.plugin = (NexusEco)plugin;
        this.economyManager = economyManager;
        this.messageManager = messageManager;
        this.permission = plugin.getConfig().getString("commands.economy.permission", "nexuseco.economy");
        this.enabled = plugin.getConfig().getBoolean("commands.economy.enabled", true);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s2, @NotNull String[] strings) {
        if (!this.enabled) {
            return false;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!player.hasPermission(this.permission)) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                this.messageManager.sendMessage(player, "general.NO_PERMISSION", placeholders);
                this.messageManager.sendActionBar(player, "general.NO_PERMISSION_ACTION_BAR", placeholders);
                return true;
            }
            if (strings.length == 0) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                this.messageManager.sendMessage(player, "economy.HELP", placeholders);
                this.messageManager.sendActionBar(player, "economy.HELP_ACTION_BAR", placeholders);
                return true;
            }
            switch (strings[0].toLowerCase()) {
                case "help": {
                    this.handleHelpCommand((CommandSender)player);
                    return true;
                }
                case "set": {
                    this.handleSetCommand((CommandSender)player, strings);
                    return true;
                }
                case "add": {
                    this.handleAddCommand((CommandSender)player, strings);
                    return true;
                }
                case "remove": {
                    this.handleRemoveCommand((CommandSender)player, strings);
                    return true;
                }
                case "reset": {
                    this.handleResetCommand((CommandSender)player, strings);
                    return true;
                }
            }
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(player, "economy.UNKNOWN_COMMAND", placeholders);
            this.messageManager.sendActionBar(player, "economy.UNKNOWN_COMMAND_ACTION_BAR", placeholders);
            return false;
        }
        if (!sender.hasPermission(this.permission)) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendConsoleMessage(sender, "general.NO_PERMISSION", placeholders);
            return true;
        }
        if (strings.length == 0) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendConsoleMessage(sender, "economy.HELP", placeholders);
            return true;
        }
        switch (strings[0].toLowerCase()) {
            case "help": {
                this.handleHelpCommand(sender);
                return true;
            }
            case "set": {
                this.handleSetCommand(sender, strings);
                return true;
            }
            case "add": {
                this.handleAddCommand(sender, strings);
                return true;
            }
            case "remove": {
                this.handleRemoveCommand(sender, strings);
                return true;
            }
            case "reset": {
                this.handleResetCommand(sender, strings);
                return true;
            }
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        this.messageManager.sendConsoleMessage(sender, "economy.UNKNOWN_COMMAND", placeholders);
        return false;
    }

    public void handleHelpCommand(CommandSender sender) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        this.messageManager.sendConsoleMessage(sender, "economy.HELP", placeholders);
    }

    public void handleSetCommand(CommandSender sender, String[] args) {
        if (args.length < 3) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendConsoleMessage(sender, "economy.SET_USAGE", placeholders);
            return;
        }
        OfflinePlayer targetPlayer = sender.getServer().getOfflinePlayer(args[1]);
        if (targetPlayer.hasPlayedBefore()) {
            this.processSetCommand(sender, targetPlayer, args[2]);
        } else {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", args[1]);
            this.messageManager.sendConsoleMessage(sender, "player.NOT_FOUND", placeholders);
        }
    }

    private void processSetCommand(CommandSender sender, OfflinePlayer target, String amountStr) {
        double amount;
        try {
            amount = NumberFormatting.reverseFormatNum(amountStr);
        }
        catch (NumberFormatException e) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendConsoleMessage(sender, "general.INVALID_AMOUNT", placeholders);
            return;
        }
        UUID targetUUID = target.getUniqueId();
        double oldBalance = this.economyManager.getBalance(targetUUID);
        this.economyManager.setBalance(targetUUID, amount);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", target.getName());
        placeholders.put("amount", NumberFormatting.formatNum(amount));
        this.messageManager.sendConsoleMessage(sender, "economy.SET_SUCCESS", placeholders);
        CompletableFuture.runAsync(() -> {
            double difference = amount - oldBalance;
            TransactionType transactionType = difference < 0.0 ? TransactionType.ADMIN_DEDUCTED : TransactionType.ADMIN_RECEIVED;
            this.economyManager.createTransactionID(null, targetUUID, Math.abs(difference), transactionType);
        });
    }

    public void handleAddCommand(CommandSender sender, String[] args) {
        if (args.length < 3) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendConsoleMessage(sender, "economy.ADD_USAGE", placeholders);
            return;
        }
        OfflinePlayer targetPlayer = sender.getServer().getOfflinePlayer(args[1]);
        if (targetPlayer.hasPlayedBefore()) {
            this.processAddCommand(sender, targetPlayer, args[2]);
        } else {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", args[1]);
            this.messageManager.sendConsoleMessage(sender, "player.NOT_FOUND", placeholders);
        }
    }

    private void processAddCommand(CommandSender sender, OfflinePlayer target, String amountStr) {
        double amount;
        try {
            amount = NumberFormatting.reverseFormatNum(amountStr);
        }
        catch (NumberFormatException e) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendConsoleMessage(sender, "general.INVALID_AMOUNT", placeholders);
            return;
        }
        UUID targetUUID = target.getUniqueId();
        this.economyManager.addBalance(targetUUID, amount);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", target.getName());
        placeholders.put("amount", NumberFormatting.formatNum(amount));
        this.messageManager.sendConsoleMessage(sender, "economy.ADD_SUCCESS", placeholders);
        CompletableFuture.runAsync(() -> this.economyManager.createTransactionID(null, targetUUID, amount, TransactionType.ADMIN_RECEIVED));
    }

    public void handleRemoveCommand(CommandSender sender, String[] args) {
        if (args.length < 3) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendConsoleMessage(sender, "economy.REMOVE_USAGE", placeholders);
            return;
        }
        OfflinePlayer targetPlayer = sender.getServer().getOfflinePlayer(args[1]);
        if (targetPlayer != null && targetPlayer.hasPlayedBefore()) {
            this.processRemoveCommand(sender, targetPlayer, args[2]);
        } else {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", args[1]);
            this.messageManager.sendConsoleMessage(sender, "player.NOT_FOUND", placeholders);
        }
    }

    private void processRemoveCommand(CommandSender sender, OfflinePlayer target, String amountStr) {
        double amount;
        try {
            amount = NumberFormatting.reverseFormatNum(amountStr);
        }
        catch (NumberFormatException e) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendConsoleMessage(sender, "general.INVALID_AMOUNT", placeholders);
            return;
        }
        UUID targetUUID = target.getUniqueId();
        this.economyManager.subtractBalance(targetUUID, amount);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", target.getName());
        placeholders.put("amount", NumberFormatting.formatNum(amount));
        this.messageManager.sendConsoleMessage(sender, "economy.REMOVE_SUCCESS", placeholders);
        CompletableFuture.runAsync(() -> this.economyManager.createTransactionID(null, targetUUID, amount, TransactionType.ADMIN_DEDUCTED));
    }

    public void handleResetCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendConsoleMessage(sender, "economy.RESET_USAGE", placeholders);
            return;
        }
        OfflinePlayer targetPlayer = sender.getServer().getOfflinePlayer(args[1]);
        if (targetPlayer != null && targetPlayer.hasPlayedBefore()) {
            this.processResetCommand(sender, targetPlayer);
        } else {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", args[1]);
            this.messageManager.sendConsoleMessage(sender, "player.NOT_FOUND", placeholders);
        }
    }

    private void processResetCommand(CommandSender sender, OfflinePlayer target) {
        UUID targetUUID = target.getUniqueId();
        double oldBalance = this.economyManager.getBalance(targetUUID);
        this.economyManager.resetBalance(targetUUID);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", target.getName());
        this.messageManager.sendConsoleMessage(sender, "economy.RESET_SUCCESS", placeholders);
        CompletableFuture.runAsync(() -> this.economyManager.createTransactionID(null, targetUUID, oldBalance, TransactionType.ADMIN_DEDUCTED));
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s2, @NotNull String[] strings) {
        Player player;
        if (!(this.enabled && commandSender instanceof Player && (player = (Player)commandSender).hasPermission(this.permission))) {
            return null;
        }
        if (strings.length == 1) {
            return List.of("help", "set", "add", "remove", "reset");
        }
        if (strings.length == 2) {
            return commandSender.getServer().getOnlinePlayers().stream().map(OfflinePlayer::getName).toList();
        }
        if (strings.length == 3 && !strings[0].equalsIgnoreCase("reset")) {
            return List.of("100", "1000", "10000", "100000", "1000000");
        }
        return null;
    }
}

