/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.command;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.harfull.nexuseco.NexusEco;
import xyz.harfull.nexuseco.gui.HistoryGUI;
import xyz.harfull.nexuseco.util.MessageManager;
import xyz.harfull.nexuseco.util.PlayerUtils;
import xyz.harfull.nexuseco.util.TaskScheduler;

public class HistoryCommand
implements CommandExecutor,
TabExecutor {
    private final HistoryGUI historyGUI;
    private final MessageManager messageManager;
    private final String permission;
    private final String otherPermission;
    private final boolean enabled;
    private final TaskScheduler taskScheduler;
    private final NexusEco plugin;

    public HistoryCommand(JavaPlugin plugin, HistoryGUI historyGUI, MessageManager messageManager) {
        this.plugin = (NexusEco)plugin;
        this.historyGUI = historyGUI;
        this.messageManager = messageManager;
        this.taskScheduler = this.plugin.getTaskScheduler();
        this.permission = plugin.getConfig().getString("commands.history.permission", "nexuseco.history");
        this.otherPermission = plugin.getConfig().getString("commands.history.other-permission", "nexuseco.history.other");
        this.enabled = plugin.getConfig().getBoolean("commands.history.enabled", true);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.enabled) {
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(MessageManager.translateColors("&cThis command can only be used by players."));
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(this.permission)) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            this.messageManager.sendMessage(player, "general.NO_PERMISSION", placeholders);
            this.messageManager.sendActionBar(player, "general.NO_PERMISSION_ACTION_BAR", placeholders);
            return true;
        }
        if (args.length == 0) {
            this.taskScheduler.runTaskAsync(() -> this.plugin.getEconomyManager().getTransactionHistory(player.getUniqueId()));
            this.taskScheduler.runEntityTask((Entity)player, p -> this.historyGUI.open(player));
            return true;
        }
        if (args.length >= 1) {
            if (!player.hasPermission(this.otherPermission)) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                this.messageManager.sendMessage(player, "general.NO_PERMISSION", placeholders);
                this.messageManager.sendActionBar(player, "general.NO_PERMISSION_ACTION_BAR", placeholders);
                return true;
            }
            Player targetPlayer = Bukkit.getPlayerExact((String)args[0]);
            if (targetPlayer != null) {
                this.taskScheduler.runTaskAsync(() -> this.plugin.getEconomyManager().getTransactionHistory(targetPlayer.getUniqueId()));
                this.taskScheduler.runEntityTask((Entity)player, p -> this.historyGUI.openOther(player, (OfflinePlayer)targetPlayer));
                return true;
            }
            CompletableFuture<OfflinePlayer> future = PlayerUtils.findPlayerAsync(args[0]);
            future.thenAccept(target -> {
                if (target != null) {
                    this.taskScheduler.runTaskAsync(() -> this.plugin.getEconomyManager().getTransactionHistory(target.getUniqueId()));
                    this.taskScheduler.runEntityTask((Entity)player, p -> this.historyGUI.openOther(player, (OfflinePlayer)target));
                } else {
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("player", args[0]);
                    this.messageManager.sendMessage(player, "player.NOT_FOUND", placeholders);
                    this.messageManager.sendActionBar(player, "player.NOT_FOUND_ACTION_BAR", placeholders);
                }
            });
            return true;
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (!this.enabled || !(sender instanceof Player)) {
            return null;
        }
        Player player = (Player)sender;
        if (args.length == 1 && player.hasPermission(this.otherPermission)) {
            return sender.getServer().getOnlinePlayers().stream().map(Player::getName).toList();
        }
        return null;
    }
}

