/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.event;

import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.harfull.nexuseco.NexusEco;
import xyz.harfull.nexuseco.economy.EconomyManager;
import xyz.harfull.nexuseco.util.TaskScheduler;

public class JoinListener
implements Listener {
    private final NexusEco plugin;
    private final EconomyManager economyManager;
    private final TaskScheduler taskScheduler;
    private final double startingBalance;

    public JoinListener(JavaPlugin plugin, EconomyManager economyManager) {
        this.plugin = (NexusEco)plugin;
        this.economyManager = economyManager;
        this.taskScheduler = this.plugin.getTaskScheduler();
        this.startingBalance = plugin.getConfig().getDouble("starting-balance", 0.0);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.taskScheduler.runEntityTask((Entity)player, p -> {
            if (this.economyManager.getBalance(p.getUniqueId()) == 0.0) {
                this.economyManager.setBalance(p.getUniqueId(), this.startingBalance);
                this.economyManager.setPayToggle(p.getUniqueId(), true);
            }
        });
    }
}

