/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.gui;

import java.io.File;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.harfull.nexuseco.NexusEco;
import xyz.harfull.nexuseco.economy.EconomyManager;
import xyz.harfull.nexuseco.model.TransactionID;
import xyz.harfull.nexuseco.model.TransactionType;
import xyz.harfull.nexuseco.util.MessageManager;
import xyz.harfull.nexuseco.util.NumberFormatting;
import xyz.harfull.nexuseco.util.TaskScheduler;

public class HistoryGUI
implements Listener {
    private final EconomyManager economyManager;
    private YamlConfiguration config;
    private final TaskScheduler taskScheduler;
    private final NexusEco plugin;
    private final File historyUIFile;
    private int size;
    private DateTimeFormatter dateTimeFormatter;
    private final Map<UUID, Integer> playerPages = new HashMap<UUID, Integer>();
    private final Map<UUID, List<TransactionID>> playerTransactions = new HashMap<UUID, List<TransactionID>>();
    private final Map<UUID, OfflinePlayer> viewingOtherPlayers = new HashMap<UUID, OfflinePlayer>();

    public HistoryGUI(JavaPlugin plugin, EconomyManager economyManager, File historyUIFile) {
        this.plugin = (NexusEco)plugin;
        this.historyUIFile = historyUIFile;
        this.economyManager = economyManager;
        this.taskScheduler = this.plugin.getTaskScheduler();
        this.config = YamlConfiguration.loadConfiguration((File)historyUIFile);
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.config.getString("date-format", "dd/MM/yyyy HH:mm"));
        this.size = this.config.getInt("gui-size", 54);
        if (this.size % 9 != 0 || this.size < 9 || this.size > 54) {
            throw new IllegalArgumentException("Invalid GUI size. Must be a multiple of 9 between 9 and 54.");
        }
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void reload() {
        this.playerPages.clear();
        this.playerTransactions.clear();
        this.config = YamlConfiguration.loadConfiguration((File)this.historyUIFile);
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.config.getString("date-format", "dd/MM/yyyy HH:mm"));
        this.size = this.config.getInt("gui-size", 54);
        if (this.size % 9 != 0 || this.size < 9 || this.size > 54) {
            throw new IllegalArgumentException("Invalid GUI size. Must be multiple of 9 between 9 and 54");
        }
    }

    public void open(Player player) {
        this.open(player, 1);
    }

    public void open(Player player, int page) {
        UUID playerUUID = player.getUniqueId();
        List<TransactionID> cachedTransactions = this.playerTransactions.get(playerUUID);
        if (cachedTransactions != null) {
            this.buildAndOpenOwnInventory(player, page, cachedTransactions);
        } else {
            this.taskScheduler.runTaskAsync(() -> {
                List<TransactionID> loadedTransactions = this.fetchAndPrepareTransactions(playerUUID);
                this.playerTransactions.put(playerUUID, loadedTransactions);
                this.buildAndOpenOwnInventory(player, page, loadedTransactions);
            });
        }
    }

    private void buildAndOpenOwnInventory(Player player, int page, List<TransactionID> transactions) {
        UUID playerUUID = player.getUniqueId();
        int maxPages = this.calculateMaxPages(transactions);
        if (page < 1) {
            page = 1;
        }
        if (page > maxPages && maxPages > 0) {
            page = maxPages;
        }
        if (maxPages == 0) {
            page = 1;
        }
        this.playerPages.put(playerUUID, page);
        String formattedTitle = this.config.getString("title", "&8Transaction History {page}/{max-page}").replace("{page}", String.valueOf(page)).replace("{max-page}", String.valueOf(Math.max(1, maxPages)));
        Component title = MessageManager.translateColors(formattedTitle);
        int finalPage = page;
        this.taskScheduler.runEntityTask((Entity)player, p -> {
            Inventory inventory = Bukkit.createInventory(null, (int)this.size, (Component)title);
            this.addFillerItems(inventory);
            this.addNavigationButtons(inventory, finalPage, maxPages);
            this.addTransactionItems(inventory, transactions, player, finalPage);
            player.openInventory(inventory);
        });
    }

    public void openOther(Player viewer, OfflinePlayer target) {
        this.openOther(viewer, target, 1);
    }

    public void openOther(Player viewer, OfflinePlayer target, int page) {
        UUID targetUUID = target.getUniqueId();
        List<TransactionID> cachedTransactions = this.playerTransactions.get(targetUUID);
        if (cachedTransactions != null) {
            this.buildAndOpenOtherInventory(viewer, target, page, cachedTransactions);
        } else {
            this.taskScheduler.runTaskAsync(() -> {
                List<TransactionID> loadedTransactions = this.fetchAndPrepareTransactions(targetUUID);
                this.playerTransactions.put(targetUUID, loadedTransactions);
                this.buildAndOpenOtherInventory(viewer, target, page, loadedTransactions);
            });
        }
    }

    private void buildAndOpenOtherInventory(Player viewer, OfflinePlayer target, int page, List<TransactionID> transactions) {
        UUID targetUUID = target.getUniqueId();
        UUID viewerUUID = viewer.getUniqueId();
        int maxPages = this.calculateMaxPages(transactions);
        if (page < 1) {
            page = 1;
        }
        if (page > maxPages && maxPages > 0) {
            page = maxPages;
        }
        if (maxPages == 0) {
            page = 1;
        }
        this.playerPages.put(viewerUUID, page);
        this.viewingOtherPlayers.put(viewerUUID, target);
        String targetName = target.getName() != null ? target.getName() : "Unknown";
        String formattedTitle = this.config.getString("title-other", "&8{player}'s History {page}/{max-page}").replace("{player}", targetName).replace("{page}", String.valueOf(page)).replace("{max-page}", String.valueOf(Math.max(1, maxPages)));
        Component title = MessageManager.translateColors(formattedTitle);
        int finalPage = page;
        this.taskScheduler.runEntityTask((Entity)viewer, p -> {
            Inventory inventory = Bukkit.createInventory(null, (int)this.size, (Component)title);
            this.addFillerItems(inventory);
            this.addNavigationButtons(inventory, finalPage, maxPages);
            this.addOtherPlayerTransactionItems(inventory, transactions, targetUUID, finalPage);
            viewer.openInventory(inventory);
        });
    }

    private List<TransactionID> fetchAndPrepareTransactions(UUID playerUUID) {
        List<TransactionID> transactions = this.economyManager.getTransactionHistory(playerUUID);
        Collections.reverse(transactions);
        ArrayList<TransactionID> displayedTransactions = new ArrayList<TransactionID>();
        for (TransactionID transaction : transactions) {
            if (transaction.getTransactionType() == TransactionType.RECEIVED && transaction.getReceiverUUID().equals(playerUUID)) {
                displayedTransactions.add(transaction);
                continue;
            }
            if (transaction.getTransactionType() == TransactionType.SENT && transaction.getSenderUUID().equals(playerUUID)) {
                displayedTransactions.add(transaction);
                continue;
            }
            if (transaction.getTransactionType() == TransactionType.ADMIN_RECEIVED && transaction.getReceiverUUID().equals(playerUUID)) {
                displayedTransactions.add(transaction);
                continue;
            }
            if (transaction.getTransactionType() != TransactionType.ADMIN_DEDUCTED || !transaction.getReceiverUUID().equals(playerUUID)) continue;
            displayedTransactions.add(transaction);
        }
        return displayedTransactions;
    }

    private int calculateMaxPages(List<TransactionID> transactions) {
        String slotRange = this.config.getString("items.transaction.slot-range", "0-44");
        int[] range = this.parseSlotRange(slotRange);
        int slotsPerPage = range[1] - range[0] + 1;
        if (transactions.isEmpty()) {
            return 0;
        }
        return (int)Math.ceil((double)transactions.size() / (double)slotsPerPage);
    }

    private void addFillerItems(Inventory inventory) {
        ConfigurationSection fillerSection = this.config.getConfigurationSection("filler");
        if (fillerSection == null) {
            return;
        }
        String material = fillerSection.getString("material", "GRAY_STAINED_GLASS_PANE");
        String name = fillerSection.getString("name", " ");
        String slotRange = fillerSection.getString("slot-range", "");
        ItemStack fillerItem = this.createItem(Material.valueOf((String)material), name, new ArrayList<String>());
        int[] range = this.parseSlotRange(slotRange);
        for (int i = range[0]; i <= range[1] && i < this.size; ++i) {
            inventory.setItem(i, fillerItem);
        }
    }

    private void addNavigationButtons(Inventory inventory, int currentPage, int maxPages) {
        if (currentPage > 1) {
            this.addButton(inventory, "previous-page");
        }
        if (currentPage < maxPages) {
            this.addButton(inventory, "next-page");
        }
        this.addButton(inventory, "close");
    }

    private void addButton(Inventory inventory, String buttonKey) {
        ConfigurationSection buttonSection = this.config.getConfigurationSection("items." + buttonKey);
        if (buttonSection == null) {
            return;
        }
        String material = buttonSection.getString("material");
        String name = buttonSection.getString("name");
        List lore = buttonSection.getStringList("lore");
        int slot = buttonSection.getInt("slot", 0);
        if (slot >= 0 && slot < this.size) {
            inventory.setItem(slot, this.createItem(Material.valueOf((String)material), name, lore));
        }
    }

    private void addTransactionItems(Inventory inventory, List<TransactionID> transactions, Player player, int page) {
        if (transactions.isEmpty()) {
            return;
        }
        String slotRange = this.config.getString("items.transaction.slot-range", "0-44");
        int[] range = this.parseSlotRange(slotRange);
        int slotsPerPage = range[1] - range[0] + 1;
        int startIndex = (page - 1) * slotsPerPage;
        int endIndex = Math.min(startIndex + slotsPerPage, transactions.size());
        int slot = range[0];
        for (int i = startIndex; i < endIndex && slot <= range[1]; ++i) {
            TransactionID transaction = transactions.get(i);
            if (transaction.getAmount() == 0.0) continue;
            ItemStack item = this.createTransactionItem(transaction, player);
            inventory.setItem(slot, item);
            ++slot;
        }
    }

    private ItemStack createTransactionItem(TransactionID transaction, Player player) {
        ConfigurationSection transactionSection = this.config.getConfigurationSection("items.transaction");
        if (transactionSection == null) {
            return new ItemStack(Material.PAPER);
        }
        String material = transactionSection.getString("material", "PAPER");
        Material itemMaterial = Material.valueOf((String)material);
        boolean isGained = transaction.getTransactionType() == TransactionType.RECEIVED || transaction.getTransactionType() == TransactionType.ADMIN_RECEIVED && transaction.getReceiverUUID().equals(player.getUniqueId());
        String nameFormat = isGained ? transactionSection.getString("gained-name", "&a+{amount}") : transactionSection.getString("lost-name", "&c-{amount}");
        String amountFormat = isGained ? transactionSection.getString("gained-amount", "&a{amount}") : transactionSection.getString("lost-amount", "&c{amount}");
        String amount = NumberFormatting.formatNum(transaction.getAmount());
        String name = nameFormat.replace("{amount}", amount);
        String formattedAmount = amountFormat.replace("{amount}", amount);
        List configLore = transactionSection.getStringList("lore");
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : configLore) {
            String senderName = transaction.getSenderUUID().equals(player.getUniqueId()) ? "You" : this.getPlayerName(transaction.getSenderUUID());
            String receiverName = transaction.getReceiverUUID().equals(player.getUniqueId()) ? "You" : this.getPlayerName(transaction.getReceiverUUID());
            String type = this.getTransactionTypeDisplay(transaction.getTransactionType());
            String from = senderName;
            String to = receiverName;
            String date = this.formatDate(transaction.getTransactionTime());
            String id = transaction.getTransactionID();
            if (type == null) {
                type = "&7Unknown";
            }
            if (from == null) {
                from = "&7Unknown";
            }
            if (to == null) {
                to = "&7Unknown";
            }
            if (date == null) {
                date = "&7Unknown";
            }
            if (id == null) {
                id = "&7Unknown";
            }
            line = line.replace("{type}", type).replace("{from}", from).replace("{to}", to).replace("{formatted-amount}", formattedAmount).replace("{date}", date).replace("{id}", id);
            lore.add(line);
        }
        return this.createItem(itemMaterial, name, lore);
    }

    private String getPlayerName(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            return player.getName();
        }
        return Bukkit.getOfflinePlayer((UUID)uuid).getName();
    }

    private String getTransactionTypeDisplay(TransactionType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TransactionType.RECEIVED -> "&aReceived";
            case TransactionType.SENT -> "&cSent";
            case TransactionType.ADMIN_RECEIVED -> "&aAdmin Received";
            case TransactionType.ADMIN_DEDUCTED -> "&cAdmin Deducted";
        };
    }

    private String formatDate(Timestamp timestamp) {
        LocalDateTime localDateTime = timestamp.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return localDateTime.format(this.dateTimeFormatter);
    }

    private ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName(MessageManager.translateColors(name));
            if (!lore.isEmpty()) {
                ArrayList<Component> coloredLore = new ArrayList<Component>();
                for (String line : lore) {
                    coloredLore.add(MessageManager.translateColors(line));
                }
                meta.lore(coloredLore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private int[] parseSlotRange(String range) {
        if (range == null || range.isEmpty()) {
            return new int[]{0, 0};
        }
        String[] parts = range.split("-");
        int start = Integer.parseInt(parts[0]);
        int end = parts.length > 1 ? Integer.parseInt(parts[1]) : start;
        return new int[]{start, end};
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        ConfigurationSection prevSection;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.playerPages.containsKey(player.getUniqueId())) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getSlot();
        int currentPage = this.playerPages.getOrDefault(player.getUniqueId(), 1);
        boolean isOtherPlayerHistory = false;
        if (this.viewingOtherPlayers.containsKey(player.getUniqueId())) {
            isOtherPlayerHistory = true;
        }
        if ((prevSection = this.config.getConfigurationSection("items.previous-page")) != null && slot == prevSection.getInt("slot")) {
            if (currentPage > 1) {
                OfflinePlayer target;
                UUID targetUUID = null;
                if (isOtherPlayerHistory && (target = (OfflinePlayer)this.viewingOtherPlayers.getOrDefault(player.getUniqueId(), null)) != null) {
                    targetUUID = target.getUniqueId();
                }
                if (targetUUID != null) {
                    target = Bukkit.getOfflinePlayer(targetUUID);
                    this.taskScheduler.runEntityTask((Entity)player, p -> this.openOther(player, target, currentPage - 1));
                } else {
                    this.taskScheduler.runEntityTask((Entity)player, p -> this.open(player, currentPage - 1));
                }
            }
            return;
        }
        ConfigurationSection nextSection = this.config.getConfigurationSection("items.next-page");
        if (nextSection != null && slot == nextSection.getInt("slot")) {
            List transactions;
            UUID targetUUID = null;
            if (isOtherPlayerHistory) {
                OfflinePlayer target = this.viewingOtherPlayers.getOrDefault(player.getUniqueId(), null);
                if (target != null) {
                    targetUUID = target.getUniqueId();
                    transactions = this.playerTransactions.getOrDefault(targetUUID, new ArrayList());
                } else {
                    transactions = this.playerTransactions.getOrDefault(player.getUniqueId(), new ArrayList());
                }
            } else {
                transactions = this.playerTransactions.getOrDefault(player.getUniqueId(), new ArrayList());
            }
            int maxPages = this.calculateMaxPages(transactions);
            if (currentPage < maxPages) {
                if (targetUUID != null) {
                    OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)targetUUID);
                    this.taskScheduler.runEntityTask((Entity)player, p -> this.openOther(player, target, currentPage + 1));
                } else {
                    this.taskScheduler.runEntityTask((Entity)player, p -> this.open(player, currentPage + 1));
                }
            }
            return;
        }
        ConfigurationSection closeSection = this.config.getConfigurationSection("items.close");
        if (closeSection != null && slot == closeSection.getInt("slot")) {
            this.taskScheduler.runEntityTask((Entity)player, p -> player.closeInventory());
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        boolean isOurGui;
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String guiTitle = this.config.getString("title", "&8Transaction History {page}/{max-page}");
        String guiTitleOther = this.config.getString("title-other", "&8{player}'s History {page}/{max-page}");
        String invTitle = event.getView().title().toString();
        boolean bl = isOurGui = invTitle != null && (invTitle.contains(guiTitle.split(" ")[0].replace("&8", "")) || invTitle.contains(guiTitleOther.split(" ")[0].replace("&8", "")));
        if (isOurGui) {
            this.taskScheduler.runTaskLater(() -> {
                if (!player.isOnline() || player.getOpenInventory() == null || !player.getOpenInventory().title().toString().contains(invTitle.split(" ")[0])) {
                    this.playerPages.remove(player.getUniqueId());
                    this.viewingOtherPlayers.remove(player.getUniqueId());
                }
            }, 2L);
        } else {
            this.playerPages.remove(player.getUniqueId());
            this.viewingOtherPlayers.remove(player.getUniqueId());
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.playerPages.remove(event.getPlayer().getUniqueId());
        this.viewingOtherPlayers.remove(event.getPlayer().getUniqueId());
    }

    public void refreshTransactions(UUID playerUUID) {
        this.playerTransactions.remove(playerUUID);
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player != null && player.isOnline() && this.playerPages.containsKey(playerUUID) && !this.viewingOtherPlayers.containsKey(playerUUID)) {
            int currentPage = this.playerPages.getOrDefault(playerUUID, 1);
            this.open(player, currentPage);
        }
        for (Map.Entry<UUID, OfflinePlayer> entry : new HashMap<UUID, OfflinePlayer>(this.viewingOtherPlayers).entrySet()) {
            Player viewer;
            UUID viewerUUID = entry.getKey();
            OfflinePlayer targetBeingViewed = entry.getValue();
            if (!targetBeingViewed.getUniqueId().equals(playerUUID) || (viewer = Bukkit.getPlayer((UUID)viewerUUID)) == null || !viewer.isOnline() || !this.playerPages.containsKey(viewerUUID)) continue;
            int currentPage = this.playerPages.getOrDefault(viewerUUID, 1);
            this.openOther(viewer, targetBeingViewed, currentPage);
        }
    }

    private void addOtherPlayerTransactionItems(Inventory inventory, List<TransactionID> transactions, UUID targetUUID, int page) {
        if (transactions.isEmpty()) {
            return;
        }
        String slotRange = this.config.getString("items.transaction.slot-range", "0-44");
        int[] range = this.parseSlotRange(slotRange);
        int slotsPerPage = range[1] - range[0] + 1;
        int startIndex = (page - 1) * slotsPerPage;
        int endIndex = Math.min(startIndex + slotsPerPage, transactions.size());
        int slot = range[0];
        for (int i = startIndex; i < endIndex && slot <= range[1]; ++i) {
            TransactionID transaction = transactions.get(i);
            if (transaction.getAmount() == 0.0) continue;
            ItemStack item = this.createOtherPlayerTransactionItem(transaction, targetUUID);
            inventory.setItem(slot, item);
            ++slot;
        }
    }

    private ItemStack createOtherPlayerTransactionItem(TransactionID transaction, UUID targetUUID) {
        ConfigurationSection transactionSection = this.config.getConfigurationSection("items.transaction");
        if (transactionSection == null) {
            return new ItemStack(Material.PAPER);
        }
        String material = transactionSection.getString("material", "PAPER");
        Material itemMaterial = Material.valueOf((String)material);
        boolean isGained = transaction.getTransactionType() == TransactionType.RECEIVED || transaction.getTransactionType() == TransactionType.ADMIN_RECEIVED && transaction.getReceiverUUID().equals(targetUUID);
        String nameFormat = isGained ? transactionSection.getString("gained-name", "&a+{amount}") : transactionSection.getString("lost-name", "&c-{amount}");
        String amountFormat = isGained ? transactionSection.getString("gained-amount", "&a{amount}") : transactionSection.getString("lost-amount", "&c{amount}");
        String amount = NumberFormatting.formatNum(transaction.getAmount());
        String name = nameFormat.replace("{amount}", amount);
        String formattedAmount = amountFormat.replace("{amount}", amount);
        List configLore = transactionSection.getStringList("lore");
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : configLore) {
            String senderName = transaction.getSenderUUID().equals(targetUUID) ? this.getPlayerName(targetUUID) : this.getPlayerName(transaction.getSenderUUID());
            String receiverName = transaction.getReceiverUUID().equals(targetUUID) ? this.getPlayerName(targetUUID) : this.getPlayerName(transaction.getReceiverUUID());
            String type = this.getTransactionTypeDisplay(transaction.getTransactionType());
            String from = senderName;
            String to = receiverName;
            String date = this.formatDate(transaction.getTransactionTime());
            String id = transaction.getTransactionID();
            if (type == null) {
                type = "&7Unknown";
            }
            if (from == null) {
                from = "&7Unknown";
            }
            if (to == null) {
                to = "&7Unknown";
            }
            if (date == null) {
                date = "&7Unknown";
            }
            if (id == null) {
                id = "&7Unknown";
            }
            line = line.replace("{type}", type).replace("{from}", from).replace("{to}", to).replace("{formatted-amount}", formattedAmount).replace("{date}", date).replace("{id}", id);
            lore.add(line);
        }
        return this.createItem(itemMaterial, name, lore);
    }
}

