/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.integration;

import java.util.List;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.harfull.nexuseco.economy.EconomyManager;
import xyz.harfull.nexuseco.util.NumberFormatting;

public class Vault
extends AbstractEconomy {
    private final JavaPlugin plugin;
    private final EconomyManager economyManager;
    private String currencyName;
    private int maxDecimalPlaces;

    public Vault(JavaPlugin plugin, EconomyManager economyManager) {
        this.plugin = plugin;
        this.economyManager = economyManager;
        this.maxDecimalPlaces = plugin.getConfig().getInt("max-decimal-places", 2);
        this.currencyName = plugin.getConfig().getString("currency-name", "dollars");
    }

    public boolean isEnabled() {
        return this.plugin.isEnabled();
    }

    public String getName() {
        return this.plugin.getName();
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return this.maxDecimalPlaces;
    }

    public String format(double v) {
        return NumberFormatting.formatNum(v);
    }

    public String currencyNamePlural() {
        return this.currencyName;
    }

    public String currencyNameSingular() {
        return this.currencyName;
    }

    public boolean hasAccount(String playerName) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
        if (!this.economyManager.hasAccount(offlinePlayer.getUniqueId())) {
            this.economyManager.createAccount(offlinePlayer.getUniqueId());
        }
        return true;
    }

    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    public double getBalance(String playerName) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
        if (!this.economyManager.hasAccount(offlinePlayer.getUniqueId())) {
            this.economyManager.createAccount(offlinePlayer.getUniqueId());
        }
        return this.economyManager.getBalance(offlinePlayer.getUniqueId());
    }

    public double getBalance(String playerName, String worldName) {
        return this.getBalance(playerName);
    }

    public boolean has(String playerName, double amount) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
        if (!this.economyManager.hasAccount(offlinePlayer.getUniqueId())) {
            this.economyManager.createAccount(offlinePlayer.getUniqueId());
        }
        return this.economyManager.hasBalance(offlinePlayer.getUniqueId(), amount);
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    public EconomyResponse withdrawPlayer(String s2, double v) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)s2);
        if (!this.economyManager.hasAccount(offlinePlayer.getUniqueId())) {
            this.economyManager.createAccount(offlinePlayer.getUniqueId());
        }
        if (this.economyManager.hasBalance(offlinePlayer.getUniqueId(), v)) {
            this.economyManager.subtractBalance(offlinePlayer.getUniqueId(), v);
            return new EconomyResponse(v, this.economyManager.getBalance(offlinePlayer.getUniqueId()), EconomyResponse.ResponseType.SUCCESS, null);
        }
        return new EconomyResponse(0.0, this.economyManager.getBalance(offlinePlayer.getUniqueId()), EconomyResponse.ResponseType.FAILURE, "not enough money");
    }

    public EconomyResponse withdrawPlayer(String s2, String s1, double v) {
        return this.withdrawPlayer(s2, v);
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
        if (!this.economyManager.hasAccount(offlinePlayer.getUniqueId())) {
            this.economyManager.createAccount(offlinePlayer.getUniqueId());
        }
        this.economyManager.addBalance(offlinePlayer.getUniqueId(), amount);
        return new EconomyResponse(amount, this.economyManager.getBalance(offlinePlayer.getUniqueId()), EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse depositPlayer(String s2, String s1, double v) {
        return this.depositPlayer(s2, v);
    }

    public EconomyResponse createBank(String s2, String s1) {
        return null;
    }

    public EconomyResponse deleteBank(String s2) {
        return null;
    }

    public EconomyResponse bankBalance(String s2) {
        return null;
    }

    public EconomyResponse bankHas(String s2, double v) {
        return null;
    }

    public EconomyResponse bankWithdraw(String s2, double v) {
        return null;
    }

    public EconomyResponse bankDeposit(String s2, double v) {
        return null;
    }

    public EconomyResponse isBankOwner(String s2, String s1) {
        return null;
    }

    public EconomyResponse isBankMember(String s2, String s1) {
        return null;
    }

    public List<String> getBanks() {
        return null;
    }

    public boolean createPlayerAccount(String s2) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)s2);
        if (!this.economyManager.hasAccount(offlinePlayer.getUniqueId())) {
            this.economyManager.createAccount(offlinePlayer.getUniqueId());
            return true;
        }
        return false;
    }

    public boolean createPlayerAccount(String s2, String s1) {
        return this.createPlayerAccount(s2);
    }
}

