/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.migration;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import xyz.harfull.nexuseco.NexusEco;
import xyz.harfull.nexuseco.migration.EconomyMigration;
import xyz.harfull.nexuseco.migration.impl.EssentialsX;
import xyz.harfull.nexuseco.model.EconomyType;

public class MigrationManager {
    private final NexusEco nexusEco;
    private final Map<EconomyType, EconomyMigration> migrations = new HashMap<EconomyType, EconomyMigration>();

    public MigrationManager(NexusEco nexusEco) {
        this.nexusEco = nexusEco;
        this.migrations.put(EconomyType.ESSENTIALS, new EssentialsX(nexusEco));
    }

    public CompletableFuture<Integer> migrateAll(EconomyType sourceType, boolean dryRun, boolean force) {
        EconomyMigration migration = this.migrations.get((Object)sourceType);
        if (migration == null) {
            throw new IllegalArgumentException("No migration found for: " + String.valueOf((Object)sourceType));
        }
        this.nexusEco.getLogger().info("Starting migration from " + sourceType.getDisplayName() + " (dryRun=" + dryRun + ", force=" + force + ")");
        return migration.migrateAll(dryRun, force).thenApply(count -> {
            this.nexusEco.getLogger().info("Migration complete. " + count + " accounts processed.");
            return count;
        });
    }
}

