/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.migration.impl;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import com.earth2me.essentials.userstorage.ModernUserMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import xyz.harfull.nexuseco.NexusEco;
import xyz.harfull.nexuseco.economy.EconomyManager;
import xyz.harfull.nexuseco.migration.EconomyMigration;
import xyz.harfull.nexuseco.util.TaskScheduler;

public class EssentialsX
implements EconomyMigration {
    private final NexusEco nexusEco;
    private final TaskScheduler taskScheduler;
    private final EconomyManager economyManager;
    private final Essentials essentials;

    public EssentialsX(NexusEco nexusEco) {
        this.nexusEco = nexusEco;
        this.taskScheduler = nexusEco.getTaskScheduler();
        this.economyManager = nexusEco.getEconomyManager();
        this.essentials = (Essentials)nexusEco.getServer().getPluginManager().getPlugin("Essentials");
    }

    @Override
    public CompletableFuture<Integer> migrateAll(boolean dryRun, boolean force) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.taskScheduler.runTaskAsync(() -> {
            ModernUserMap userMap = this.essentials.getUsers();
            Set userUUIDs = userMap.getAllUserUUIDs();
            AtomicInteger migratedCount = new AtomicInteger(0);
            ArrayList syncFutures = new ArrayList();
            for (UUID uuid : userUUIDs) {
                try {
                    User user = userMap.loadUncachedUser(uuid);
                    if (user == null) continue;
                    double balance = user.getMoney().doubleValue();
                    String playerName = user.getName();
                    if (dryRun) {
                        this.nexusEco.getLogger().info("[DryRun] EssentialsX balance for " + playerName + ": " + balance);
                        migratedCount.incrementAndGet();
                        continue;
                    }
                    CompletableFuture syncFuture = new CompletableFuture();
                    this.taskScheduler.runTask(() -> {
                        try {
                            boolean alreadyExists = this.checkIfBalanceExists(uuid);
                            if (alreadyExists && !force) {
                                this.nexusEco.getLogger().info("Skipping " + playerName + " because balance exists and force is false");
                                syncFuture.complete(null);
                                return;
                            }
                            boolean success = this.migrateBalance(uuid, balance);
                            if (success) {
                                this.nexusEco.getLogger().info("Migrated EssentialsX balance for " + playerName + ": " + balance);
                                migratedCount.incrementAndGet();
                            } else {
                                this.nexusEco.getLogger().warning("Failed to migrate balance for " + playerName);
                            }
                            syncFuture.complete(null);
                        }
                        catch (Exception ex) {
                            this.nexusEco.getLogger().severe("Error migrating balance for " + playerName + ": " + String.valueOf(ex));
                            syncFuture.completeExceptionally(ex);
                        }
                    });
                    syncFutures.add(syncFuture);
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    this.nexusEco.getLogger().severe("Error processing user with UUID " + String.valueOf(uuid) + ":\n" + String.valueOf(sw));
                }
            }
            CompletableFuture.allOf(syncFutures.toArray(new CompletableFuture[0])).whenComplete((v, ex) -> {
                if (ex != null) {
                    future.completeExceptionally((Throwable)ex);
                } else {
                    future.complete(migratedCount.get());
                }
            });
            if (dryRun || syncFutures.isEmpty()) {
                future.complete(migratedCount.get());
            }
        });
        return future;
    }

    private boolean checkIfBalanceExists(UUID uuid) {
        return this.economyManager.getBalance(uuid) != 0.0;
    }

    private boolean migrateBalance(UUID uuid, double balance) {
        this.economyManager.setBalance(uuid, balance);
        return true;
    }
}

