/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class NumberFormatting {
    private static int maxDecimalPlaces;
    private static boolean abbreviateFormat;
    private static boolean largeAbbreviation;
    private static final String[] SUFFIXES_LOWER;
    private static final String[] SUFFIXES_UPPER;
    private static final BigDecimal[] POWERS;

    public static void loadConfig(JavaPlugin plugin) {
        FileConfiguration config = plugin.getConfig();
        maxDecimalPlaces = config.getInt("max-decimal-places", 2);
        abbreviateFormat = config.getBoolean("abbreviate-format", true);
        largeAbbreviation = config.getBoolean("large-abbreviation", true);
    }

    public static String formatNum(double num) {
        String[] suffixes;
        if (num < 0.0) {
            return "-" + NumberFormatting.formatNum(-num);
        }
        if (!abbreviateFormat || num < 1000.0) {
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(maxDecimalPlaces);
            df.setMinimumFractionDigits(0);
            df.setGroupingUsed(true);
            return df.format(num);
        }
        int index = (int)(Math.log10(num) / 3.0);
        index = Math.min(index, SUFFIXES_LOWER.length - 1);
        double scaledNum = num / Math.pow(1000.0, index);
        String[] stringArray = suffixes = largeAbbreviation ? SUFFIXES_UPPER : SUFFIXES_LOWER;
        if (scaledNum == (double)((int)scaledNum)) {
            return String.format("%d%s", (int)scaledNum, suffixes[index]);
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(maxDecimalPlaces);
        df.setMinimumFractionDigits(0);
        df.setGroupingUsed(false);
        return df.format(scaledNum) + suffixes[index];
    }

    public static double reverseFormatNum(String num) {
        double value;
        if (num == null || num.isEmpty()) {
            return 0.0;
        }
        int sign = num.startsWith("-") ? -1 : 1;
        num = num.replace("-", "").trim();
        String numericPart = num.replaceAll("[^0-9.]", "");
        String suffixPart = num.replaceAll("[0-9.,]", "").trim().toLowerCase();
        try {
            value = Double.parseDouble(numericPart);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
        for (int i = SUFFIXES_LOWER.length - 1; i > 0; --i) {
            if (!suffixPart.equals(SUFFIXES_LOWER[i]) && !suffixPart.equals(SUFFIXES_UPPER[i].toLowerCase())) continue;
            return BigDecimal.valueOf(value).multiply(POWERS[i]).doubleValue() * (double)sign;
        }
        return value * (double)sign;
    }

    static {
        SUFFIXES_LOWER = new String[]{"", "k", "m", "b", "t", "q", "qi", "sx", "sp", "oc", "no", "de", "ud", "dd", "td", "qd"};
        SUFFIXES_UPPER = new String[]{"", "K", "M", "B", "T", "Q", "QI", "SX", "SP", "OC", "NO", "DE", "UD", "DD", "TD", "QD"};
        POWERS = new BigDecimal[16];
        for (int i = 0; i < POWERS.length; ++i) {
            NumberFormatting.POWERS[i] = BigDecimal.valueOf(1000L).pow(i);
        }
    }
}

