/*
 * Decompiled with CFR 0.152.
 */
package xyz.harfull.nexuseco.util;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class TaskScheduler {
    private final Plugin plugin;
    private final boolean isFolia;

    public TaskScheduler(Plugin plugin, boolean isFolia) {
        this.plugin = plugin;
        this.isFolia = isFolia;
    }

    public void runTask(Runnable task) {
        if (this.isFolia) {
            Bukkit.getGlobalRegionScheduler().execute(this.plugin, task);
        } else {
            Bukkit.getScheduler().runTask(this.plugin, task);
        }
    }

    public void runTaskLater(Runnable task, long delay) {
        if (this.isFolia) {
            Bukkit.getGlobalRegionScheduler().runDelayed(this.plugin, scheduledTask -> task.run(), delay);
        } else {
            Bukkit.getScheduler().runTaskLater(this.plugin, task, delay);
        }
    }

    public void runTaskTimer(Runnable task, long delay, long period) {
        if (this.isFolia) {
            Bukkit.getGlobalRegionScheduler().runAtFixedRate(this.plugin, scheduledTask -> task.run(), delay, period);
        } else {
            Bukkit.getScheduler().runTaskTimer(this.plugin, task, delay, period);
        }
    }

    public void runTaskAsync(Runnable task) {
        if (this.isFolia) {
            Bukkit.getAsyncScheduler().runNow(this.plugin, scheduledTask -> task.run());
        } else {
            Bukkit.getScheduler().runTaskAsynchronously(this.plugin, task);
        }
    }

    public void runTaskLaterAsync(Runnable task, long delay) {
        if (this.isFolia) {
            Bukkit.getAsyncScheduler().runDelayed(this.plugin, scheduledTask -> task.run(), delay * 50L, TimeUnit.MILLISECONDS);
        } else {
            Bukkit.getScheduler().runTaskLaterAsynchronously(this.plugin, task, delay);
        }
    }

    public void runEntityTask(Entity entity, Consumer<Entity> task) {
        if (this.isFolia) {
            entity.getScheduler().run(this.plugin, scheduledTask -> task.accept(entity), () -> {});
        } else {
            Bukkit.getScheduler().runTask(this.plugin, () -> task.accept(entity));
        }
    }
}

