/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import java.util.HashMap;
import java.util.Map;

public enum AuthenticationMechanism {
    GSSAPI("GSSAPI"),
    MONGODB_AWS("MONGODB-AWS"),
    MONGODB_OIDC("MONGODB-OIDC"),
    MONGODB_X509("MONGODB-X509"),
    PLAIN("PLAIN"),
    SCRAM_SHA_1("SCRAM-SHA-1"),
    SCRAM_SHA_256("SCRAM-SHA-256");

    private static final Map<String, AuthenticationMechanism> AUTH_MAP;
    private final String mechanismName;

    private AuthenticationMechanism(String string2) {
        this.mechanismName = string2;
    }

    public String getMechanismName() {
        return this.mechanismName;
    }

    public String toString() {
        return this.mechanismName;
    }

    public static AuthenticationMechanism fromMechanismName(String string) {
        AuthenticationMechanism authenticationMechanism = AUTH_MAP.get(string);
        if (authenticationMechanism == null) {
            throw new IllegalArgumentException("Unsupported authMechanism: " + string);
        }
        return authenticationMechanism;
    }

    static {
        AUTH_MAP = new HashMap<String, AuthenticationMechanism>();
        for (AuthenticationMechanism authenticationMechanism : AuthenticationMechanism.values()) {
            AUTH_MAP.put(authenticationMechanism.getMechanismName(), authenticationMechanism);
        }
    }
}

