/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoClientSettings;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.bson.BsonDocument;

public final class AutoEncryptionSettings {
    private final MongoClientSettings keyVaultMongoClientSettings;
    private final String keyVaultNamespace;
    private final Map<String, Map<String, Object>> kmsProviders;
    private final Map<String, SSLContext> kmsProviderSslContextMap;
    private final Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers;
    private final Map<String, BsonDocument> schemaMap;
    private final Map<String, Object> extraOptions;
    private final boolean bypassAutoEncryption;
    private final Map<String, BsonDocument> encryptedFieldsMap;
    private final boolean bypassQueryAnalysis;

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public MongoClientSettings getKeyVaultMongoClientSettings() {
        return this.keyVaultMongoClientSettings;
    }

    public String getKeyVaultNamespace() {
        return this.keyVaultNamespace;
    }

    public Map<String, Map<String, Object>> getKmsProviders() {
        return Collections.unmodifiableMap(this.kmsProviders);
    }

    public Map<String, Supplier<Map<String, Object>>> getKmsProviderPropertySuppliers() {
        return Collections.unmodifiableMap(this.kmsProviderPropertySuppliers);
    }

    public Map<String, SSLContext> getKmsProviderSslContextMap() {
        return Collections.unmodifiableMap(this.kmsProviderSslContextMap);
    }

    public Map<String, BsonDocument> getSchemaMap() {
        return this.schemaMap;
    }

    public Map<String, Object> getExtraOptions() {
        return this.extraOptions;
    }

    public boolean isBypassAutoEncryption() {
        return this.bypassAutoEncryption;
    }

    @Nullable
    public Map<String, BsonDocument> getEncryptedFieldsMap() {
        return this.encryptedFieldsMap;
    }

    public boolean isBypassQueryAnalysis() {
        return this.bypassQueryAnalysis;
    }

    private AutoEncryptionSettings(Builder builder) {
        this.keyVaultMongoClientSettings = builder.keyVaultMongoClientSettings;
        this.keyVaultNamespace = Assertions.notNull("keyVaultNamespace", builder.keyVaultNamespace);
        this.kmsProviders = Assertions.notNull("kmsProviders", builder.kmsProviders);
        this.kmsProviderSslContextMap = Assertions.notNull("kmsProviderSslContextMap", builder.kmsProviderSslContextMap);
        this.kmsProviderPropertySuppliers = Assertions.notNull("kmsProviderPropertySuppliers", builder.kmsProviderPropertySuppliers);
        this.schemaMap = Assertions.notNull("schemaMap", builder.schemaMap);
        this.extraOptions = Assertions.notNull("extraOptions", builder.extraOptions);
        this.bypassAutoEncryption = builder.bypassAutoEncryption;
        this.encryptedFieldsMap = builder.encryptedFieldsMap;
        this.bypassQueryAnalysis = builder.bypassQueryAnalysis;
    }

    public String toString() {
        return "AutoEncryptionSettings{<hidden>}";
    }

    @NotThreadSafe
    public static final class Builder {
        private MongoClientSettings keyVaultMongoClientSettings;
        private String keyVaultNamespace;
        private Map<String, Map<String, Object>> kmsProviders;
        private Map<String, SSLContext> kmsProviderSslContextMap = new HashMap<String, SSLContext>();
        private Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers = new HashMap<String, Supplier<Map<String, Object>>>();
        private Map<String, BsonDocument> schemaMap = Collections.emptyMap();
        private Map<String, Object> extraOptions = Collections.emptyMap();
        private boolean bypassAutoEncryption;
        private Map<String, BsonDocument> encryptedFieldsMap = Collections.emptyMap();
        private boolean bypassQueryAnalysis;

        public Builder keyVaultMongoClientSettings(MongoClientSettings mongoClientSettings) {
            this.keyVaultMongoClientSettings = mongoClientSettings;
            return this;
        }

        public Builder keyVaultNamespace(String string) {
            this.keyVaultNamespace = Assertions.notNull("keyVaultNamespace", string);
            return this;
        }

        public Builder kmsProviders(Map<String, Map<String, Object>> map) {
            this.kmsProviders = Assertions.notNull("kmsProviders", map);
            return this;
        }

        public Builder kmsProviderPropertySuppliers(Map<String, Supplier<Map<String, Object>>> map) {
            this.kmsProviderPropertySuppliers = Assertions.notNull("kmsProviderPropertySuppliers", map);
            return this;
        }

        public Builder kmsProviderSslContextMap(Map<String, SSLContext> map) {
            this.kmsProviderSslContextMap = Assertions.notNull("kmsProviderSslContextMap", map);
            return this;
        }

        public Builder schemaMap(Map<String, BsonDocument> map) {
            this.schemaMap = Assertions.notNull("schemaMap", map);
            return this;
        }

        public Builder extraOptions(Map<String, Object> map) {
            this.extraOptions = Assertions.notNull("extraOptions", map);
            return this;
        }

        public Builder bypassAutoEncryption(boolean bl) {
            this.bypassAutoEncryption = bl;
            return this;
        }

        public Builder encryptedFieldsMap(Map<String, BsonDocument> map) {
            this.encryptedFieldsMap = Assertions.notNull("encryptedFieldsMap", map);
            return this;
        }

        public Builder bypassQueryAnalysis(boolean bl) {
            this.bypassQueryAnalysis = bl;
            return this;
        }

        public AutoEncryptionSettings build() {
            return new AutoEncryptionSettings(this);
        }

        private Builder() {
        }
    }
}

