/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import com.mongodb.DBObjectCodec;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.io.BasicOutputBuffer;
import org.bson.json.JsonMode;
import org.bson.json.JsonReader;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;
import org.bson.types.BasicBSONList;

public class BasicDBObject
extends BasicBSONObject
implements DBObject,
Bson {
    private static final long serialVersionUID = -4415279469780082174L;
    private static final Codec<BasicDBObject> DEFAULT_CODEC = CodecRegistries.withUuidRepresentation(DBObjectCodec.getDefaultRegistry(), UuidRepresentation.STANDARD).get(BasicDBObject.class);
    private boolean isPartialObject;

    public static BasicDBObject parse(String string) {
        return BasicDBObject.parse(string, DEFAULT_CODEC);
    }

    public static BasicDBObject parse(String string, Decoder<BasicDBObject> decoder) {
        return decoder.decode(new JsonReader(string), DecoderContext.builder().build());
    }

    public BasicDBObject() {
    }

    public BasicDBObject(int n) {
        super(n);
    }

    public BasicDBObject(String string, Object object) {
        super(string, object);
    }

    public BasicDBObject(Map map) {
        super(map);
    }

    @Override
    public BasicDBObject append(String string, Object object) {
        this.put(string, object);
        return this;
    }

    @Override
    public boolean isPartialObject() {
        return this.isPartialObject;
    }

    public String toJson() {
        return this.toJson(JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build());
    }

    public String toJson(JsonWriterSettings jsonWriterSettings) {
        return this.toJson(jsonWriterSettings, DEFAULT_CODEC);
    }

    public String toJson(Encoder<BasicDBObject> encoder) {
        return this.toJson(JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build(), encoder);
    }

    public String toJson(JsonWriterSettings jsonWriterSettings, Encoder<BasicDBObject> encoder) {
        JsonWriter jsonWriter = new JsonWriter(new StringWriter(), jsonWriterSettings);
        encoder.encode(jsonWriter, this, EncoderContext.builder().build());
        return jsonWriter.getWriter().toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BSONObject)) {
            return false;
        }
        BSONObject bSONObject = (BSONObject)object;
        if (!this.keySet().equals(bSONObject.keySet())) {
            return false;
        }
        return Arrays.equals(BasicDBObject.toBson(BasicDBObject.canonicalizeBSONObject(this)), BasicDBObject.toBson(BasicDBObject.canonicalizeBSONObject(bSONObject)));
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(BasicDBObject.toBson(BasicDBObject.canonicalizeBSONObject(this)));
    }

    private static byte[] toBson(BasicDBObject basicDBObject) {
        BasicOutputBuffer basicOutputBuffer = new BasicOutputBuffer();
        DEFAULT_CODEC.encode(new BsonBinaryWriter(basicOutputBuffer), basicDBObject, EncoderContext.builder().build());
        return basicOutputBuffer.toByteArray();
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    @Override
    public void markAsPartialObject() {
        this.isPartialObject = true;
    }

    public Object copy() {
        BasicDBObject basicDBObject = new BasicDBObject(this.toMap());
        for (String string : this.keySet()) {
            Object object = this.get(string);
            if (object instanceof BasicDBObject) {
                basicDBObject.put(string, ((BasicDBObject)object).copy());
                continue;
            }
            if (!(object instanceof BasicDBList)) continue;
            basicDBObject.put(string, ((BasicDBList)object).copy());
        }
        return basicDBObject;
    }

    @Override
    public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
        return new BsonDocumentWrapper<BasicDBObject>(this, codecRegistry.get(BasicDBObject.class));
    }

    private static Object canonicalize(Object object) {
        if (object instanceof BSONObject && !(object instanceof BasicBSONList)) {
            return BasicDBObject.canonicalizeBSONObject((BSONObject)object);
        }
        if (object instanceof List) {
            return BasicDBObject.canonicalizeList((List)object);
        }
        if (object instanceof Map) {
            return BasicDBObject.canonicalizeMap((Map)object);
        }
        return object;
    }

    private static Map<String, Object> canonicalizeMap(Map<String, Object> map) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(map.size());
        TreeSet<String> treeSet = new TreeSet<String>(map.keySet());
        for (String string : treeSet) {
            Object object = map.get(string);
            linkedHashMap.put(string, BasicDBObject.canonicalize(object));
        }
        return linkedHashMap;
    }

    private static BasicDBObject canonicalizeBSONObject(BSONObject bSONObject) {
        BasicDBObject basicDBObject = new BasicDBObject();
        TreeSet<String> treeSet = new TreeSet<String>(bSONObject.keySet());
        for (String string : treeSet) {
            Object object = bSONObject.get(string);
            basicDBObject.put(string, BasicDBObject.canonicalize(object));
        }
        return basicDBObject;
    }

    private static List canonicalizeList(List<Object> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (Object object : list) {
            arrayList.add(BasicDBObject.canonicalize(object));
        }
        return arrayList;
    }
}

