/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.LinkedList;
import java.util.Map;

public class BasicDBObjectBuilder {
    private final LinkedList<DBObject> _stack = new LinkedList();

    public BasicDBObjectBuilder() {
        this._stack.add(new BasicDBObject());
    }

    public static BasicDBObjectBuilder start() {
        return new BasicDBObjectBuilder();
    }

    public static BasicDBObjectBuilder start(String string, Object object) {
        return new BasicDBObjectBuilder().add(string, object);
    }

    public static BasicDBObjectBuilder start(Map map) {
        BasicDBObjectBuilder basicDBObjectBuilder = new BasicDBObjectBuilder();
        for (Map.Entry entry : map.entrySet()) {
            basicDBObjectBuilder.add(entry.getKey().toString(), entry.getValue());
        }
        return basicDBObjectBuilder;
    }

    public BasicDBObjectBuilder append(String string, Object object) {
        this._cur().put(string, object);
        return this;
    }

    public BasicDBObjectBuilder add(String string, Object object) {
        return this.append(string, object);
    }

    public BasicDBObjectBuilder push(String string) {
        BasicDBObject basicDBObject = new BasicDBObject();
        this._cur().put(string, basicDBObject);
        this._stack.addLast(basicDBObject);
        return this;
    }

    public BasicDBObjectBuilder pop() {
        if (this._stack.size() <= 1) {
            throw new IllegalArgumentException("can't pop last element");
        }
        this._stack.removeLast();
        return this;
    }

    public DBObject get() {
        return this._stack.getFirst();
    }

    public boolean isEmpty() {
        return ((BasicDBObject)this._stack.getFirst()).size() == 0;
    }

    private DBObject _cur() {
        return this._stack.getLast();
    }
}

