/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoException;
import com.mongodb.MongoServerException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteError;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.client.model.bulk.ClientBulkWriteResult;
import com.mongodb.internal.operation.ClientBulkWriteOperation;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class ClientBulkWriteException
extends MongoServerException {
    private static final long serialVersionUID = 1L;
    private final List<WriteConcernError> writeConcernErrors;
    private final Map<Integer, WriteError> writeErrors;
    @Nullable
    private final ClientBulkWriteResult partialResult;

    public ClientBulkWriteException(@Nullable MongoException mongoException, @Nullable List<WriteConcernError> list, @Nullable Map<Integer, WriteError> map, @Nullable ClientBulkWriteResult clientBulkWriteResult, ServerAddress serverAddress) {
        super(ClientBulkWriteException.message(mongoException, list, map, clientBulkWriteResult, Assertions.notNull("serverAddress", serverAddress)), ClientBulkWriteException.validateServerAddress(mongoException, serverAddress));
        this.initCause(mongoException);
        Assertions.isTrueArgument("At least one of `writeConcernErrors`, `writeErrors`, `partialResult` must be non-null or non-empty", list != null && !list.isEmpty() || map != null && !map.isEmpty() || clientBulkWriteResult != null);
        this.writeConcernErrors = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        this.writeErrors = map == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
        this.partialResult = clientBulkWriteResult;
    }

    private static String message(@Nullable MongoException mongoException, @Nullable List<WriteConcernError> list, @Nullable Map<Integer, WriteError> map, @Nullable ClientBulkWriteResult clientBulkWriteResult, ServerAddress serverAddress) {
        return "Client-level bulk write operation error on server " + serverAddress + "." + (mongoException == null ? "" : " Top-level error: " + mongoException + ".") + (map == null || map.isEmpty() ? "" : " Write errors: " + map + ".") + (list == null || list.isEmpty() ? "" : " Write concern errors: " + list + ".") + (clientBulkWriteResult == null ? "" : " Partial result: " + clientBulkWriteResult + ".");
    }

    private static ServerAddress validateServerAddress(@Nullable MongoException mongoException, ServerAddress serverAddress) {
        ClientBulkWriteOperation.Exceptions.serverAddressFromException(mongoException).ifPresent(serverAddress2 -> Assertions.isTrueArgument("`serverAddress` must be equal to that of the `error`", serverAddress2.equals(serverAddress)));
        return mongoException instanceof MongoServerException ? ((MongoServerException)mongoException).getServerAddress() : serverAddress;
    }

    @Override
    @Nullable
    public MongoException getCause() {
        return (MongoException)super.getCause();
    }

    public List<WriteConcernError> getWriteConcernErrors() {
        return this.writeConcernErrors;
    }

    public Map<Integer, WriteError> getWriteErrors() {
        return this.writeErrors;
    }

    public Optional<ClientBulkWriteResult> getPartialResult() {
        return Optional.ofNullable(this.partialResult);
    }
}

