/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoClientSettings;
import com.mongodb.annotations.Alpha;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.annotations.Reason;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;

public final class ClientEncryptionSettings {
    private final MongoClientSettings keyVaultMongoClientSettings;
    private final String keyVaultNamespace;
    private final Map<String, Map<String, Object>> kmsProviders;
    private final Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers;
    private final Map<String, SSLContext> kmsProviderSslContextMap;
    @Nullable
    private final Long timeoutMS;

    public static Builder builder() {
        return new Builder();
    }

    public MongoClientSettings getKeyVaultMongoClientSettings() {
        return this.keyVaultMongoClientSettings;
    }

    public String getKeyVaultNamespace() {
        return this.keyVaultNamespace;
    }

    public Map<String, Map<String, Object>> getKmsProviders() {
        return Collections.unmodifiableMap(this.kmsProviders);
    }

    public Map<String, Supplier<Map<String, Object>>> getKmsProviderPropertySuppliers() {
        return Collections.unmodifiableMap(this.kmsProviderPropertySuppliers);
    }

    public Map<String, SSLContext> getKmsProviderSslContextMap() {
        return Collections.unmodifiableMap(this.kmsProviderSslContextMap);
    }

    @Nullable
    @Alpha(value={Reason.CLIENT})
    public Long getTimeout(TimeUnit timeUnit) {
        return this.timeoutMS == null ? null : Long.valueOf(timeUnit.convert(this.timeoutMS, TimeUnit.MILLISECONDS));
    }

    private ClientEncryptionSettings(Builder builder) {
        this.keyVaultMongoClientSettings = Assertions.notNull("keyVaultMongoClientSettings", builder.keyVaultMongoClientSettings);
        this.keyVaultNamespace = Assertions.notNull("keyVaultNamespace", builder.keyVaultNamespace);
        this.kmsProviders = Assertions.notNull("kmsProviders", builder.kmsProviders);
        this.kmsProviderPropertySuppliers = Assertions.notNull("kmsProviderPropertySuppliers", builder.kmsProviderPropertySuppliers);
        this.kmsProviderSslContextMap = Assertions.notNull("kmsProviderSslContextMap", builder.kmsProviderSslContextMap);
        this.timeoutMS = builder.timeoutMS;
    }

    @NotThreadSafe
    public static final class Builder {
        private MongoClientSettings keyVaultMongoClientSettings;
        private String keyVaultNamespace;
        private Map<String, Map<String, Object>> kmsProviders;
        private Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers = new HashMap<String, Supplier<Map<String, Object>>>();
        private Map<String, SSLContext> kmsProviderSslContextMap = new HashMap<String, SSLContext>();
        @Nullable
        private Long timeoutMS;

        public Builder keyVaultMongoClientSettings(MongoClientSettings mongoClientSettings) {
            this.keyVaultMongoClientSettings = Assertions.notNull("keyVaultMongoClientSettings", mongoClientSettings);
            return this;
        }

        public Builder keyVaultNamespace(String string) {
            this.keyVaultNamespace = Assertions.notNull("keyVaultNamespace", string);
            return this;
        }

        public Builder kmsProviders(Map<String, Map<String, Object>> map) {
            this.kmsProviders = Assertions.notNull("kmsProviders", map);
            return this;
        }

        public Builder kmsProviderPropertySuppliers(Map<String, Supplier<Map<String, Object>>> map) {
            this.kmsProviderPropertySuppliers = Assertions.notNull("kmsProviderPropertySuppliers", map);
            return this;
        }

        public Builder kmsProviderSslContextMap(Map<String, SSLContext> map) {
            this.kmsProviderSslContextMap = Assertions.notNull("kmsProviderSslContextMap", map);
            return this;
        }

        @Alpha(value={Reason.CLIENT})
        public Builder timeout(long l, TimeUnit timeUnit) {
            this.timeoutMS = TimeoutSettings.convertAndValidateTimeout(l, timeUnit);
            return this;
        }

        public ClientEncryptionSettings build() {
            return new ClientEncryptionSettings(this);
        }

        private Builder() {
        }
    }
}

