/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.TransactionOptions;
import com.mongodb.annotations.Alpha;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.annotations.Reason;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.lang.Nullable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Immutable
public final class ClientSessionOptions {
    private final Boolean causallyConsistent;
    private final Boolean snapshot;
    private final Long defaultTimeoutMS;
    private final TransactionOptions defaultTransactionOptions;

    @Nullable
    public Boolean isCausallyConsistent() {
        return this.causallyConsistent;
    }

    @Nullable
    public Boolean isSnapshot() {
        return this.snapshot;
    }

    public TransactionOptions getDefaultTransactionOptions() {
        return this.defaultTransactionOptions;
    }

    @Nullable
    @Alpha(value={Reason.CLIENT})
    public Long getDefaultTimeout(TimeUnit timeUnit) {
        return this.defaultTimeoutMS == null ? null : Long.valueOf(timeUnit.convert(this.defaultTimeoutMS, TimeUnit.MILLISECONDS));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClientSessionOptions clientSessionOptions = (ClientSessionOptions)object;
        return Objects.equals(this.causallyConsistent, clientSessionOptions.causallyConsistent) && Objects.equals(this.snapshot, clientSessionOptions.snapshot) && Objects.equals(this.defaultTimeoutMS, clientSessionOptions.defaultTimeoutMS) && Objects.equals(this.defaultTransactionOptions, clientSessionOptions.defaultTransactionOptions);
    }

    public int hashCode() {
        return Objects.hash(this.causallyConsistent, this.snapshot, this.defaultTimeoutMS, this.defaultTransactionOptions);
    }

    public String toString() {
        return "ClientSessionOptions{causallyConsistent=" + this.causallyConsistent + ", snapshot=" + this.snapshot + ", defaultTimeoutMS=" + this.defaultTimeoutMS + ", defaultTransactionOptions=" + this.defaultTransactionOptions + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClientSessionOptions clientSessionOptions) {
        Assertions.notNull("options", clientSessionOptions);
        Builder builder = new Builder();
        builder.causallyConsistent = clientSessionOptions.isCausallyConsistent();
        builder.snapshot = clientSessionOptions.isSnapshot();
        builder.defaultTransactionOptions = clientSessionOptions.getDefaultTransactionOptions();
        builder.defaultTimeoutMS = clientSessionOptions.defaultTimeoutMS;
        return builder;
    }

    private ClientSessionOptions(Builder builder) {
        if (builder.causallyConsistent != null && builder.causallyConsistent.booleanValue() && builder.snapshot != null && builder.snapshot.booleanValue()) {
            throw new IllegalArgumentException("A session can not be both a snapshot and causally consistent");
        }
        this.causallyConsistent = builder.causallyConsistent != null || builder.snapshot == null ? builder.causallyConsistent : Boolean.valueOf(builder.snapshot == false);
        this.snapshot = builder.snapshot;
        this.defaultTransactionOptions = builder.defaultTransactionOptions;
        this.defaultTimeoutMS = builder.defaultTimeoutMS;
    }

    @NotThreadSafe
    public static final class Builder {
        private Boolean causallyConsistent;
        private Boolean snapshot;
        private Long defaultTimeoutMS;
        private TransactionOptions defaultTransactionOptions = TransactionOptions.builder().build();

        public Builder causallyConsistent(boolean bl) {
            this.causallyConsistent = bl;
            return this;
        }

        public Builder snapshot(boolean bl) {
            this.snapshot = bl;
            return this;
        }

        public Builder defaultTransactionOptions(TransactionOptions transactionOptions) {
            this.defaultTransactionOptions = Assertions.notNull("defaultTransactionOptions", transactionOptions);
            return this;
        }

        @Alpha(value={Reason.CLIENT})
        public Builder defaultTimeout(long l, TimeUnit timeUnit) {
            this.defaultTimeoutMS = TimeoutSettings.convertAndValidateTimeout(l, timeUnit, "defaultTimeout");
            return this;
        }

        public ClientSessionOptions build() {
            return new ClientSessionOptions(this);
        }

        private Builder() {
        }
    }
}

