/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.MongoCompressor;
import com.mongodb.MongoConfigurationException;
import com.mongodb.MongoCredential;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadConcernLevel;
import com.mongodb.ReadPreference;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.Alpha;
import com.mongodb.annotations.Reason;
import com.mongodb.connection.ServerMonitoringMode;
import com.mongodb.internal.connection.OidcAuthenticator;
import com.mongodb.internal.connection.ServerMonitoringModeUtil;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.dns.DefaultDnsResolver;
import com.mongodb.lang.Nullable;
import com.mongodb.spi.dns.DnsClient;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.UuidRepresentation;

public class ConnectionString {
    private static final String MONGODB_PREFIX = "mongodb://";
    private static final String MONGODB_SRV_PREFIX = "mongodb+srv://";
    private static final Set<String> ALLOWED_OPTIONS_IN_TXT_RECORD = new HashSet<String>(Arrays.asList("authsource", "replicaset", "loadbalanced"));
    private static final Logger LOGGER = Loggers.getLogger("uri");
    private static final List<String> MECHANISM_KEYS_DISALLOWED_IN_CONNECTION_STRING = Stream.of("ALLOWED_HOSTS").map(string -> string.toLowerCase()).collect(Collectors.toList());
    private final MongoCredential credential;
    private final boolean isSrvProtocol;
    private final List<String> hosts;
    private final String database;
    private final String collection;
    private final String connectionString;
    private Integer srvMaxHosts;
    private String srvServiceName;
    private Boolean directConnection;
    private Boolean loadBalanced;
    private ReadPreference readPreference;
    private WriteConcern writeConcern;
    private Boolean retryWrites;
    private Boolean retryReads;
    private ReadConcern readConcern;
    private Integer minConnectionPoolSize;
    private Integer maxConnectionPoolSize;
    private Integer maxWaitTime;
    private Integer maxConnectionIdleTime;
    private Integer maxConnectionLifeTime;
    private Integer maxConnecting;
    private Integer connectTimeout;
    private Long timeout;
    private Integer socketTimeout;
    private Boolean sslEnabled;
    private Boolean sslInvalidHostnameAllowed;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String requiredReplicaSetName;
    private Integer serverSelectionTimeout;
    private Integer localThreshold;
    private Integer heartbeatFrequency;
    private ServerMonitoringMode serverMonitoringMode;
    private String applicationName;
    private List<MongoCompressor> compressorList;
    private UuidRepresentation uuidRepresentation;
    private static final Set<String> GENERAL_OPTIONS_KEYS = new LinkedHashSet<String>();
    private static final Set<String> AUTH_KEYS = new HashSet<String>();
    private static final Set<String> READ_PREFERENCE_KEYS = new HashSet<String>();
    private static final Set<String> WRITE_CONCERN_KEYS = new HashSet<String>();
    private static final Set<String> COMPRESSOR_KEYS = new HashSet<String>();
    private static final Set<String> ALL_KEYS = new HashSet<String>();
    private static final Set<String> TRUE_VALUES;
    private static final Set<String> FALSE_VALUES;

    public ConnectionString(String string) {
        this(string, null);
    }

    public ConnectionString(String string, @Nullable DnsClient dnsClient) {
        String string2;
        String string3;
        String string4;
        this.connectionString = string;
        boolean bl = string.startsWith(MONGODB_PREFIX);
        this.isSrvProtocol = string.startsWith(MONGODB_SRV_PREFIX);
        if (!bl && !this.isSrvProtocol) {
            throw new IllegalArgumentException(String.format("The connection string is invalid. Connection strings must start with either '%s' or '%s", MONGODB_PREFIX, MONGODB_SRV_PREFIX));
        }
        String string5 = bl ? string.substring(MONGODB_PREFIX.length()) : string.substring(MONGODB_SRV_PREFIX.length());
        int n = string5.indexOf("/");
        int n2 = string5.indexOf("?");
        if (n2 == -1 && n == -1) {
            string4 = string5;
            string5 = "";
        } else if (n2 != -1 && (n == -1 || n2 < n)) {
            string4 = string5.substring(0, n2);
            string5 = string5.substring(n2);
        } else {
            string4 = string5.substring(0, n);
            string5 = string5.substring(n + 1);
        }
        String string6 = null;
        char[] cArray = null;
        int n3 = string4.lastIndexOf("@");
        if (n3 > 0) {
            String string7 = string4.substring(0, n3).replace("+", "%2B");
            string3 = string4.substring(n3 + 1);
            int n4 = this.countOccurrences(string7, ":");
            if (string7.contains("@") || n4 > 1) {
                throw new IllegalArgumentException("The connection string contains invalid user information. If the username or password contains a colon (:) or an at-sign (@) then it must be urlencoded");
            }
            if (n4 == 0) {
                string6 = this.urldecode(string7);
            } else {
                n3 = string7.indexOf(":");
                if (n3 == 0) {
                    throw new IllegalArgumentException("No username is provided in the connection string");
                }
                string6 = this.urldecode(string7.substring(0, n3));
                cArray = this.urldecode(string7.substring(n3 + 1), true).toCharArray();
            }
        } else {
            if (n3 == 0) {
                throw new IllegalArgumentException("The connection string contains an at-sign (@) without a user name");
            }
            string3 = string4;
        }
        List<String> list = Collections.unmodifiableList(this.parseHosts(Arrays.asList(string3.split(","))));
        if (this.isSrvProtocol) {
            if (list.size() > 1) {
                throw new IllegalArgumentException("Only one host allowed when using mongodb+srv protocol");
            }
            if (list.get(0).contains(":")) {
                throw new IllegalArgumentException("Host for when using mongodb+srv protocol can not contain a port");
            }
        }
        this.hosts = list;
        n3 = string5.indexOf("?");
        if (n3 == -1) {
            string2 = string5;
            string5 = "";
        } else {
            string2 = string5.substring(0, n3);
            string5 = string5.substring(n3 + 1);
        }
        if (string2.length() > 0) {
            n3 = (string2 = this.urldecode(string2)).indexOf(".");
            if (n3 < 0) {
                this.database = string2;
                this.collection = null;
            } else {
                this.database = string2.substring(0, n3);
                this.collection = string2.substring(n3 + 1);
            }
            MongoNamespace.checkDatabaseNameValidity(this.database);
        } else {
            this.database = null;
            this.collection = null;
        }
        String string8 = this.isSrvProtocol ? new DefaultDnsResolver(dnsClient).resolveAdditionalQueryParametersFromTxtRecords(list.get(0)) : "";
        String string9 = string5;
        Map<String, List<String>> map = this.parseOptions(string9);
        Map<String, List<String>> map2 = this.parseOptions(string8);
        if (!ALLOWED_OPTIONS_IN_TXT_RECORD.containsAll(map2.keySet())) {
            throw new MongoConfigurationException(String.format("A TXT record is only permitted to contain the keys %s, but the TXT record for '%s' contains the keys %s", ALLOWED_OPTIONS_IN_TXT_RECORD, list.get(0), map2.keySet()));
        }
        Map<String, List<String>> map3 = this.combineOptionsMaps(map2, map);
        if (this.isSrvProtocol && !map3.containsKey("tls") && !map3.containsKey("ssl")) {
            map3.put("tls", Collections.singletonList("true"));
        }
        this.translateOptions(map3);
        if (!this.isSrvProtocol && this.srvMaxHosts != null) {
            throw new IllegalArgumentException("srvMaxHosts can only be specified with mongodb+srv protocol");
        }
        if (!this.isSrvProtocol && this.srvServiceName != null) {
            throw new IllegalArgumentException("srvServiceName can only be specified with mongodb+srv protocol");
        }
        if (this.directConnection != null && this.directConnection.booleanValue()) {
            if (this.isSrvProtocol) {
                throw new IllegalArgumentException("Direct connections are not supported when using mongodb+srv protocol");
            }
            if (this.hosts.size() > 1) {
                throw new IllegalArgumentException("Direct connections are not supported when using multiple hosts");
            }
        }
        if (this.loadBalanced != null && this.loadBalanced.booleanValue()) {
            if (this.directConnection != null && this.directConnection.booleanValue()) {
                throw new IllegalArgumentException("directConnection=true can not be specified with loadBalanced=true");
            }
            if (this.requiredReplicaSetName != null) {
                throw new IllegalArgumentException("replicaSet can not be specified with loadBalanced=true");
            }
            if (this.hosts.size() > 1) {
                throw new IllegalArgumentException("Only one host can be specified with loadBalanced=true");
            }
            if (this.srvMaxHosts != null && this.srvMaxHosts > 0) {
                throw new IllegalArgumentException("srvMaxHosts can not be specified with loadBalanced=true");
            }
        }
        if (this.requiredReplicaSetName != null && this.srvMaxHosts != null && this.srvMaxHosts > 0) {
            throw new IllegalArgumentException("srvMaxHosts can not be specified with replica set name");
        }
        this.validateProxyParameters();
        this.credential = this.createCredentials(map3, string6, cArray);
        this.warnOnUnsupportedOptions(map3);
    }

    private Map<String, List<String>> combineOptionsMaps(Map<String, List<String>> map, Map<String, List<String>> map2) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(map);
        hashMap.putAll(map2);
        return hashMap;
    }

    private void warnOnUnsupportedOptions(Map<String, List<String>> map) {
        if (LOGGER.isWarnEnabled()) {
            map.keySet().stream().filter(string -> !ALL_KEYS.contains(string)).forEach(string -> LOGGER.warn(String.format("Connection string contains unsupported option '%s'.", string)));
        }
    }

    private void translateOptions(Map<String, List<String>> map) {
        boolean bl = false;
        boolean bl2 = false;
        for (String string : GENERAL_OPTIONS_KEYS) {
            String string2 = this.getLastValue(map, string);
            if (string2 == null) continue;
            switch (string) {
                case "maxpoolsize": {
                    this.maxConnectionPoolSize = this.parseInteger(string2, "maxpoolsize");
                    break;
                }
                case "minpoolsize": {
                    this.minConnectionPoolSize = this.parseInteger(string2, "minpoolsize");
                    break;
                }
                case "maxidletimems": {
                    this.maxConnectionIdleTime = this.parseInteger(string2, "maxidletimems");
                    break;
                }
                case "maxlifetimems": {
                    this.maxConnectionLifeTime = this.parseInteger(string2, "maxlifetimems");
                    break;
                }
                case "maxconnecting": {
                    this.maxConnecting = this.parseInteger(string2, "maxConnecting");
                    break;
                }
                case "waitqueuetimeoutms": {
                    this.maxWaitTime = this.parseInteger(string2, "waitqueuetimeoutms");
                    break;
                }
                case "connecttimeoutms": {
                    this.connectTimeout = this.parseInteger(string2, "connecttimeoutms");
                    break;
                }
                case "sockettimeoutms": {
                    this.socketTimeout = this.parseInteger(string2, "sockettimeoutms");
                    break;
                }
                case "timeoutms": {
                    this.timeout = this.parseLong(string2, "timeoutms");
                    break;
                }
                case "proxyhost": {
                    this.proxyHost = string2;
                    break;
                }
                case "proxyport": {
                    this.proxyPort = this.parseInteger(string2, "proxyPort");
                    break;
                }
                case "proxyusername": {
                    this.proxyUsername = string2;
                    break;
                }
                case "proxypassword": {
                    this.proxyPassword = string2;
                    break;
                }
                case "tlsallowinvalidhostnames": {
                    this.sslInvalidHostnameAllowed = this.parseBoolean(string2, "tlsAllowInvalidHostnames");
                    bl2 = true;
                    break;
                }
                case "sslinvalidhostnameallowed": {
                    this.sslInvalidHostnameAllowed = this.parseBoolean(string2, "sslinvalidhostnameallowed");
                    bl2 = true;
                    break;
                }
                case "tlsinsecure": {
                    this.sslInvalidHostnameAllowed = this.parseBoolean(string2, "tlsinsecure");
                    bl = true;
                    break;
                }
                case "ssl": {
                    this.initializeSslEnabled("ssl", string2);
                    break;
                }
                case "tls": {
                    this.initializeSslEnabled("tls", string2);
                    break;
                }
                case "replicaset": {
                    this.requiredReplicaSetName = string2;
                    break;
                }
                case "readconcernlevel": {
                    this.readConcern = new ReadConcern(ReadConcernLevel.fromString(string2));
                    break;
                }
                case "serverselectiontimeoutms": {
                    this.serverSelectionTimeout = this.parseInteger(string2, "serverselectiontimeoutms");
                    break;
                }
                case "localthresholdms": {
                    this.localThreshold = this.parseInteger(string2, "localthresholdms");
                    break;
                }
                case "heartbeatfrequencyms": {
                    this.heartbeatFrequency = this.parseInteger(string2, "heartbeatfrequencyms");
                    break;
                }
                case "servermonitoringmode": {
                    this.serverMonitoringMode = ServerMonitoringModeUtil.fromString(string2);
                    break;
                }
                case "appname": {
                    this.applicationName = string2;
                    break;
                }
                case "retrywrites": {
                    this.retryWrites = this.parseBoolean(string2, "retrywrites");
                    break;
                }
                case "retryreads": {
                    this.retryReads = this.parseBoolean(string2, "retryreads");
                    break;
                }
                case "uuidrepresentation": {
                    this.uuidRepresentation = this.createUuidRepresentation(string2);
                    break;
                }
                case "directconnection": {
                    this.directConnection = this.parseBoolean(string2, "directconnection");
                    break;
                }
                case "loadbalanced": {
                    this.loadBalanced = this.parseBoolean(string2, "loadbalanced");
                    break;
                }
                case "srvmaxhosts": {
                    this.srvMaxHosts = this.parseInteger(string2, "srvmaxhosts");
                    if (this.srvMaxHosts >= 0) break;
                    throw new IllegalArgumentException("srvMaxHosts must be >= 0");
                }
                case "srvservicename": {
                    this.srvServiceName = string2;
                    break;
                }
            }
        }
        if (bl && bl2) {
            throw new IllegalArgumentException("tlsAllowInvalidHostnames or sslInvalidHostnameAllowed set along with tlsInsecure is not allowed");
        }
        this.writeConcern = this.createWriteConcern(map);
        this.readPreference = this.createReadPreference(map);
        this.compressorList = this.createCompressors(map);
    }

    private void initializeSslEnabled(String string, String string2) {
        Boolean bl = this.parseBoolean(string2, string);
        if (this.sslEnabled != null && !this.sslEnabled.equals(bl)) {
            throw new IllegalArgumentException("Conflicting tls and ssl parameter values are not allowed");
        }
        this.sslEnabled = bl;
    }

    private List<MongoCompressor> createCompressors(Map<String, List<String>> map) {
        String string = "";
        Integer n = null;
        for (String string2 : COMPRESSOR_KEYS) {
            String string3 = this.getLastValue(map, string2);
            if (string3 == null) continue;
            if (string2.equals("compressors")) {
                string = string3;
                continue;
            }
            if (!string2.equals("zlibcompressionlevel")) continue;
            n = Integer.parseInt(string3);
        }
        return this.buildCompressors(string, n);
    }

    private List<MongoCompressor> buildCompressors(String string, @Nullable Integer n) {
        ArrayList<MongoCompressor> arrayList = new ArrayList<MongoCompressor>();
        for (String string2 : string.split(",")) {
            if (string2.equals("zlib")) {
                MongoCompressor mongoCompressor = MongoCompressor.createZlibCompressor();
                if (n != null) {
                    mongoCompressor = mongoCompressor.withProperty("LEVEL", n);
                }
                arrayList.add(mongoCompressor);
                continue;
            }
            if (string2.equals("snappy")) {
                arrayList.add(MongoCompressor.createSnappyCompressor());
                continue;
            }
            if (string2.equals("zstd")) {
                arrayList.add(MongoCompressor.createZstdCompressor());
                continue;
            }
            if (string2.isEmpty()) continue;
            throw new IllegalArgumentException("Unsupported compressor '" + string2 + "'");
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Nullable
    private WriteConcern createWriteConcern(Map<String, List<String>> map) {
        String string = null;
        Integer n = null;
        Boolean bl = null;
        Boolean bl2 = null;
        for (String string2 : WRITE_CONCERN_KEYS) {
            String string3 = this.getLastValue(map, string2);
            if (string3 == null) continue;
            switch (string2) {
                case "safe": {
                    bl = this.parseBoolean(string3, "safe");
                    break;
                }
                case "w": {
                    string = string3;
                    break;
                }
                case "wtimeoutms": {
                    n = Integer.parseInt(string3);
                    break;
                }
                case "journal": {
                    bl2 = this.parseBoolean(string3, "journal");
                    break;
                }
            }
        }
        return this.buildWriteConcern(bl, string, n, bl2);
    }

    @Nullable
    private ReadPreference createReadPreference(Map<String, List<String>> map) {
        String string = null;
        ArrayList<TagSet> arrayList = new ArrayList<TagSet>();
        long l = -1L;
        block10: for (String string2 : READ_PREFERENCE_KEYS) {
            String string3 = this.getLastValue(map, string2);
            if (string3 == null) continue;
            switch (string2) {
                case "readpreference": {
                    string = string3;
                    break;
                }
                case "maxstalenessseconds": {
                    l = this.parseInteger(string3, "maxstalenessseconds");
                    break;
                }
                case "readpreferencetags": {
                    for (String string4 : map.get(string2)) {
                        TagSet tagSet = this.getTags(string4.trim());
                        arrayList.add(tagSet);
                    }
                    continue block10;
                }
            }
        }
        return this.buildReadPreference(string, arrayList, l);
    }

    private UuidRepresentation createUuidRepresentation(String string) {
        if (string.equalsIgnoreCase("unspecified")) {
            return UuidRepresentation.UNSPECIFIED;
        }
        if (string.equalsIgnoreCase("javaLegacy")) {
            return UuidRepresentation.JAVA_LEGACY;
        }
        if (string.equalsIgnoreCase("csharpLegacy")) {
            return UuidRepresentation.C_SHARP_LEGACY;
        }
        if (string.equalsIgnoreCase("pythonLegacy")) {
            return UuidRepresentation.PYTHON_LEGACY;
        }
        if (string.equalsIgnoreCase("standard")) {
            return UuidRepresentation.STANDARD;
        }
        throw new IllegalArgumentException("Unknown uuid representation: " + string);
    }

    @Nullable
    private MongoCredential createCredentials(Map<String, List<String>> map, @Nullable String string, @Nullable char[] cArray) {
        AuthenticationMechanism authenticationMechanism = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (String stringArray : AUTH_KEYS) {
            String string5 = this.getLastValue(map, stringArray);
            if (string5 == null) continue;
            switch (stringArray) {
                case "authmechanism": {
                    if (string5.equals("MONGODB-CR")) {
                        if (string == null) {
                            throw new IllegalArgumentException("username can not be null");
                        }
                        LOGGER.warn("Deprecated MONGDOB-CR authentication mechanism used in connection string");
                        break;
                    }
                    authenticationMechanism = AuthenticationMechanism.fromMechanismName(string5);
                    break;
                }
                case "authsource": {
                    if (string5.equals("")) {
                        throw new IllegalArgumentException("authSource can not be an empty string");
                    }
                    string2 = string5;
                    break;
                }
                case "gssapiservicename": {
                    string3 = string5;
                    break;
                }
                case "authmechanismproperties": {
                    string4 = string5;
                    break;
                }
            }
        }
        Object object = null;
        if (authenticationMechanism != null) {
            object = this.createMongoCredentialWithMechanism(authenticationMechanism, string, cArray, string2, string3);
        } else if (string != null) {
            object = MongoCredential.createCredential(string, this.getAuthSourceOrDefault(string2, this.database != null ? this.database : "admin"), cArray);
        }
        if (object != null && string4 != null) {
            for (String string6 : string4.split(",")) {
                String[] stringArray = string6.split(":", 2);
                if (stringArray.length != 2) {
                    throw new IllegalArgumentException(String.format("The connection string contains invalid authentication properties. '%s' is not a key value pair", string6));
                }
                String string7 = stringArray[0].trim().toLowerCase();
                String string8 = stringArray[1].trim();
                if (MECHANISM_KEYS_DISALLOWED_IN_CONNECTION_STRING.contains(string7)) {
                    throw new IllegalArgumentException(String.format("The connection string contains disallowed mechanism properties. '%s' must be set on the credential programmatically.", string7));
                }
                object = string7.equals("canonicalize_host_name") ? ((MongoCredential)object).withMechanismProperty(string7, Boolean.valueOf(string8)) : ((MongoCredential)object).withMechanismProperty(string7, string8);
            }
        }
        return object;
    }

    private MongoCredential createMongoCredentialWithMechanism(AuthenticationMechanism authenticationMechanism, String string, @Nullable char[] cArray, @Nullable String string2, @Nullable String string3) {
        MongoCredential mongoCredential;
        String string4;
        switch (authenticationMechanism) {
            case PLAIN: {
                string4 = this.getAuthSourceOrDefault(string2, this.database != null ? this.database : "$external");
                break;
            }
            case GSSAPI: 
            case MONGODB_X509: {
                string4 = this.getAuthSourceOrDefault(string2, "$external");
                if (string4.equals("$external")) break;
                throw new IllegalArgumentException(String.format("Invalid authSource for %s, it must be '$external'", new Object[]{authenticationMechanism}));
            }
            default: {
                string4 = this.getAuthSourceOrDefault(string2, this.database != null ? this.database : "admin");
            }
        }
        switch (authenticationMechanism) {
            case GSSAPI: {
                mongoCredential = MongoCredential.createGSSAPICredential(string);
                if (string3 != null) {
                    mongoCredential = mongoCredential.withMechanismProperty("SERVICE_NAME", string3);
                }
                if (cArray == null || !LOGGER.isWarnEnabled()) break;
                LOGGER.warn("Password in connection string not used with MONGODB_X509 authentication mechanism.");
                break;
            }
            case PLAIN: {
                mongoCredential = MongoCredential.createPlainCredential(string, string4, cArray);
                break;
            }
            case MONGODB_X509: {
                if (cArray != null) {
                    throw new IllegalArgumentException("Invalid mechanism, MONGODB_x509 does not support passwords");
                }
                mongoCredential = MongoCredential.createMongoX509Credential(string);
                break;
            }
            case SCRAM_SHA_1: {
                mongoCredential = MongoCredential.createScramSha1Credential(string, string4, cArray);
                break;
            }
            case SCRAM_SHA_256: {
                mongoCredential = MongoCredential.createScramSha256Credential(string, string4, cArray);
                break;
            }
            case MONGODB_AWS: {
                mongoCredential = MongoCredential.createAwsCredential(string, cArray);
                break;
            }
            case MONGODB_OIDC: {
                OidcAuthenticator.OidcValidator.validateCreateOidcCredential(cArray);
                mongoCredential = MongoCredential.createOidcCredential(string);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The connection string contains an invalid authentication mechanism'. '%s' is not a supported authentication mechanism", new Object[]{authenticationMechanism}));
            }
        }
        return mongoCredential;
    }

    private String getAuthSourceOrDefault(@Nullable String string, String string2) {
        if (string != null) {
            return string;
        }
        return string2;
    }

    @Nullable
    private String getLastValue(Map<String, List<String>> map, String string) {
        List<String> list = map.get(string);
        if (list == null) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    private Map<String, List<String>> parseOptions(String string) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (string.isEmpty()) {
            return hashMap;
        }
        for (String string2 : string.split("&|;")) {
            if (string2.isEmpty()) continue;
            int n = string2.indexOf("=");
            if (n >= 0) {
                String string3 = string2.substring(0, n).toLowerCase();
                String string4 = string2.substring(n + 1);
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string3);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>(1);
                }
                arrayList.add(this.urldecode(string4));
                hashMap.put(string3, arrayList);
                continue;
            }
            throw new IllegalArgumentException(String.format("The connection string contains an invalid option '%s'. '%s' is missing the value delimiter eg '%s=value'", string, string2, string2));
        }
        if (hashMap.containsKey("wtimeout") && !hashMap.containsKey("wtimeoutms")) {
            hashMap.put("wtimeoutms", (List)hashMap.remove("wtimeout"));
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Uri option 'wtimeout' has been deprecated, use 'wtimeoutms' instead.");
            }
        }
        if (hashMap.containsKey("j") && !hashMap.containsKey("journal")) {
            hashMap.put("journal", (List)hashMap.remove("j"));
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Uri option 'j' has been deprecated, use 'journal' instead.");
            }
        }
        return hashMap;
    }

    @Nullable
    private ReadPreference buildReadPreference(@Nullable String string, List<TagSet> list, long l) {
        if (string != null) {
            if (list.isEmpty() && l == -1L) {
                return ReadPreference.valueOf(string);
            }
            if (l == -1L) {
                return ReadPreference.valueOf(string, list);
            }
            return ReadPreference.valueOf(string, list, l, TimeUnit.SECONDS);
        }
        if (!list.isEmpty() || l != -1L) {
            throw new IllegalArgumentException("Read preference mode must be specified if either read preference tags or max staleness is specified");
        }
        return null;
    }

    @Nullable
    private WriteConcern buildWriteConcern(@Nullable Boolean bl, @Nullable String string, @Nullable Integer n, @Nullable Boolean bl2) {
        WriteConcern writeConcern = null;
        if (string != null || n != null || bl2 != null) {
            if (string == null) {
                writeConcern = WriteConcern.ACKNOWLEDGED;
            } else {
                try {
                    writeConcern = new WriteConcern(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    writeConcern = new WriteConcern(string);
                }
            }
            if (n != null) {
                writeConcern = writeConcern.withWTimeout(n.intValue(), TimeUnit.MILLISECONDS);
            }
            if (bl2 != null) {
                writeConcern = writeConcern.withJournal(bl2);
            }
            return writeConcern;
        }
        if (bl != null) {
            writeConcern = bl != false ? WriteConcern.ACKNOWLEDGED : WriteConcern.UNACKNOWLEDGED;
        }
        return writeConcern;
    }

    private TagSet getTags(String string) {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        if (string.length() > 0) {
            for (String string2 : string.split(",")) {
                String[] stringArray = string2.split(":");
                if (stringArray.length != 2) {
                    throw new IllegalArgumentException(String.format("The connection string contains an invalid read preference tag. '%s' is not a key value pair", string));
                }
                arrayList.add(new Tag(stringArray[0].trim(), stringArray[1].trim()));
            }
        }
        return new TagSet(arrayList);
    }

    @Nullable
    private Boolean parseBoolean(String string, String string2) {
        String string3 = string.trim().toLowerCase();
        if (TRUE_VALUES.contains(string3)) {
            if (!string3.equals("true")) {
                LOGGER.warn(String.format("Deprecated boolean value '%s' in the connection string for '%s'. Replace with 'true'", string3, string2));
            }
            return true;
        }
        if (FALSE_VALUES.contains(string3)) {
            if (!string3.equals("false")) {
                LOGGER.warn(String.format("Deprecated boolean value '%s' in the connection string for '%s'. Replace with'false'", string3, string2));
            }
            return false;
        }
        LOGGER.warn(String.format("Ignoring unrecognized boolean value '%s' in the connection string for '%s'. Replace with either 'true' or 'false'", string3, string2));
        return null;
    }

    private int parseInteger(String string, String string2) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.format("The connection string contains an invalid value for '%s'. '%s' is not a valid integer", string2, string));
        }
    }

    private long parseLong(String string, String string2) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.format("The connection string contains an invalid value for '%s'. '%s' is not a valid long", string2, string));
        }
    }

    private List<String> parseHosts(List<String> list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("The connection string must contain at least one host");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            int n;
            if (string.length() == 0) {
                throw new IllegalArgumentException(String.format("The connection string contains an empty host '%s'. ", list));
            }
            if (string.endsWith(".sock")) {
                string = this.urldecode(string);
            } else if (string.startsWith("[")) {
                if (!string.contains("]")) {
                    throw new IllegalArgumentException(String.format("The connection string contains an invalid host '%s'. IPv6 address literals must be enclosed in '[' and ']' according to RFC 2732", string));
                }
                n = string.indexOf("]:");
                if (n != -1) {
                    this.validatePort(string.substring(n + 2));
                }
            } else {
                n = this.countOccurrences(string, ":");
                if (n > 1) {
                    throw new IllegalArgumentException(String.format("The connection string contains an invalid host '%s'. Reserved characters such as ':' must be escaped according RFC 2396. Any IPv6 address literal must be enclosed in '[' and ']' according to RFC 2732.", string));
                }
                if (n == 1) {
                    this.validatePort(string.substring(string.indexOf(":") + 1));
                }
            }
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private void validatePort(String string) {
        try {
            int n = Integer.parseInt(string);
            if (n <= 0 || n > 65535) {
                throw new IllegalArgumentException("The connection string contains an invalid host and port. The port must be an integer between 0 and 65535.");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("The connection string contains an invalid host and port. The port contains non-digit characters, it must be an integer between 0 and 65535. Hint: username and password must be escaped according to RFC 3986.");
        }
    }

    private void validateProxyParameters() {
        if (this.proxyHost == null) {
            if (this.proxyPort != null) {
                throw new IllegalArgumentException("proxyPort can only be specified with proxyHost");
            }
            if (this.proxyUsername != null) {
                throw new IllegalArgumentException("proxyUsername can only be specified with proxyHost");
            }
            if (this.proxyPassword != null) {
                throw new IllegalArgumentException("proxyPassword can only be specified with proxyHost");
            }
        }
        if (this.proxyPort != null && (this.proxyPort < 0 || this.proxyPort > 65535)) {
            throw new IllegalArgumentException("proxyPort should be within the valid range (0 to 65535)");
        }
        if (this.proxyUsername != null) {
            if (this.proxyUsername.isEmpty()) {
                throw new IllegalArgumentException("proxyUsername cannot be empty");
            }
            if (this.proxyUsername.getBytes(StandardCharsets.UTF_8).length >= 255) {
                throw new IllegalArgumentException("username's length in bytes cannot be greater than 255");
            }
        }
        if (this.proxyPassword != null) {
            if (this.proxyPassword.isEmpty()) {
                throw new IllegalArgumentException("proxyPassword cannot be empty");
            }
            if (this.proxyPassword.getBytes(StandardCharsets.UTF_8).length >= 255) {
                throw new IllegalArgumentException("password's length in bytes cannot be greater than 255");
            }
        }
        if (this.proxyUsername == null ^ this.proxyPassword == null) {
            throw new IllegalArgumentException("Both proxyUsername and proxyPassword must be set together. They cannot be set individually");
        }
    }

    private int countOccurrences(String string, String string2) {
        return string.length() - string.replace(string2, "").length();
    }

    private String urldecode(String string) {
        return this.urldecode(string, false);
    }

    private String urldecode(String string, boolean bl) {
        try {
            return URLDecoder.decode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (bl) {
                throw new IllegalArgumentException("The connection string contained unsupported characters in the password.");
            }
            throw new IllegalArgumentException(String.format("The connection string contained unsupported characters: '%s'.Decoding produced the following error: %s", string, unsupportedEncodingException.getMessage()));
        }
    }

    @Nullable
    public String getUsername() {
        return this.credential != null ? this.credential.getUserName() : null;
    }

    @Nullable
    public char[] getPassword() {
        return this.credential != null ? this.credential.getPassword() : null;
    }

    public boolean isSrvProtocol() {
        return this.isSrvProtocol;
    }

    @Nullable
    public Integer getSrvMaxHosts() {
        return this.srvMaxHosts;
    }

    @Nullable
    public String getSrvServiceName() {
        return this.srvServiceName;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    @Nullable
    public String getDatabase() {
        return this.database;
    }

    @Nullable
    public String getCollection() {
        return this.collection;
    }

    @Nullable
    public Boolean isDirectConnection() {
        return this.directConnection;
    }

    @Nullable
    public Boolean isLoadBalanced() {
        return this.loadBalanced;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    @Nullable
    public MongoCredential getCredential() {
        return this.credential;
    }

    @Nullable
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Nullable
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Nullable
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Nullable
    public Boolean getRetryWritesValue() {
        return this.retryWrites;
    }

    @Nullable
    public Boolean getRetryReads() {
        return this.retryReads;
    }

    @Nullable
    public Integer getMinConnectionPoolSize() {
        return this.minConnectionPoolSize;
    }

    @Nullable
    public Integer getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    @Nullable
    public Integer getMaxWaitTime() {
        return this.maxWaitTime;
    }

    @Nullable
    public Integer getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    @Nullable
    public Integer getMaxConnectionLifeTime() {
        return this.maxConnectionLifeTime;
    }

    @Nullable
    public Integer getMaxConnecting() {
        return this.maxConnecting;
    }

    @Nullable
    @Alpha(value={Reason.CLIENT})
    public Long getTimeout() {
        return this.timeout;
    }

    @Nullable
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Nullable
    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    @Nullable
    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    @Nullable
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Nullable
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Nullable
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Nullable
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Nullable
    public Boolean getSslInvalidHostnameAllowed() {
        return this.sslInvalidHostnameAllowed;
    }

    @Nullable
    public String getRequiredReplicaSetName() {
        return this.requiredReplicaSetName;
    }

    @Nullable
    public Integer getServerSelectionTimeout() {
        return this.serverSelectionTimeout;
    }

    @Nullable
    public Integer getLocalThreshold() {
        return this.localThreshold;
    }

    @Nullable
    public Integer getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    @Nullable
    public ServerMonitoringMode getServerMonitoringMode() {
        return this.serverMonitoringMode;
    }

    @Nullable
    public String getApplicationName() {
        return this.applicationName;
    }

    public List<MongoCompressor> getCompressorList() {
        return this.compressorList;
    }

    @Nullable
    public UuidRepresentation getUuidRepresentation() {
        return this.uuidRepresentation;
    }

    public String toString() {
        return this.connectionString;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConnectionString connectionString = (ConnectionString)object;
        return this.isSrvProtocol == connectionString.isSrvProtocol && Objects.equals(this.directConnection, connectionString.directConnection) && Objects.equals(this.credential, connectionString.credential) && Objects.equals(this.hosts, connectionString.hosts) && Objects.equals(this.database, connectionString.database) && Objects.equals(this.collection, connectionString.collection) && Objects.equals(this.readPreference, connectionString.readPreference) && Objects.equals(this.writeConcern, connectionString.writeConcern) && Objects.equals(this.retryWrites, connectionString.retryWrites) && Objects.equals(this.retryReads, connectionString.retryReads) && Objects.equals(this.readConcern, connectionString.readConcern) && Objects.equals(this.minConnectionPoolSize, connectionString.minConnectionPoolSize) && Objects.equals(this.maxConnectionPoolSize, connectionString.maxConnectionPoolSize) && Objects.equals(this.maxWaitTime, connectionString.maxWaitTime) && Objects.equals(this.maxConnectionIdleTime, connectionString.maxConnectionIdleTime) && Objects.equals(this.maxConnectionLifeTime, connectionString.maxConnectionLifeTime) && Objects.equals(this.maxConnecting, connectionString.maxConnecting) && Objects.equals(this.connectTimeout, connectionString.connectTimeout) && Objects.equals(this.timeout, connectionString.timeout) && Objects.equals(this.socketTimeout, connectionString.socketTimeout) && Objects.equals(this.proxyHost, connectionString.proxyHost) && Objects.equals(this.proxyPort, connectionString.proxyPort) && Objects.equals(this.proxyUsername, connectionString.proxyUsername) && Objects.equals(this.proxyPassword, connectionString.proxyPassword) && Objects.equals(this.sslEnabled, connectionString.sslEnabled) && Objects.equals(this.sslInvalidHostnameAllowed, connectionString.sslInvalidHostnameAllowed) && Objects.equals(this.requiredReplicaSetName, connectionString.requiredReplicaSetName) && Objects.equals(this.serverSelectionTimeout, connectionString.serverSelectionTimeout) && Objects.equals(this.localThreshold, connectionString.localThreshold) && Objects.equals(this.heartbeatFrequency, connectionString.heartbeatFrequency) && Objects.equals((Object)this.serverMonitoringMode, (Object)connectionString.serverMonitoringMode) && Objects.equals(this.applicationName, connectionString.applicationName) && Objects.equals(this.compressorList, connectionString.compressorList) && Objects.equals((Object)this.uuidRepresentation, (Object)connectionString.uuidRepresentation) && Objects.equals(this.srvServiceName, connectionString.srvServiceName) && Objects.equals(this.srvMaxHosts, connectionString.srvMaxHosts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.credential, this.isSrvProtocol, this.hosts, this.database, this.collection, this.directConnection, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.minConnectionPoolSize, this.maxConnectionPoolSize, this.maxWaitTime, this.maxConnectionIdleTime, this.maxConnectionLifeTime, this.maxConnecting, this.connectTimeout, this.timeout, this.socketTimeout, this.sslEnabled, this.sslInvalidHostnameAllowed, this.requiredReplicaSetName, this.serverSelectionTimeout, this.localThreshold, this.heartbeatFrequency, this.serverMonitoringMode, this.applicationName, this.compressorList, this.uuidRepresentation, this.srvServiceName, this.srvMaxHosts, this.proxyHost, this.proxyPort, this.proxyUsername, this.proxyPassword});
    }

    static {
        GENERAL_OPTIONS_KEYS.add("minpoolsize");
        GENERAL_OPTIONS_KEYS.add("maxpoolsize");
        GENERAL_OPTIONS_KEYS.add("timeoutms");
        GENERAL_OPTIONS_KEYS.add("sockettimeoutms");
        GENERAL_OPTIONS_KEYS.add("waitqueuetimeoutms");
        GENERAL_OPTIONS_KEYS.add("connecttimeoutms");
        GENERAL_OPTIONS_KEYS.add("maxidletimems");
        GENERAL_OPTIONS_KEYS.add("maxlifetimems");
        GENERAL_OPTIONS_KEYS.add("maxconnecting");
        GENERAL_OPTIONS_KEYS.add("ssl");
        GENERAL_OPTIONS_KEYS.add("tls");
        GENERAL_OPTIONS_KEYS.add("tlsinsecure");
        GENERAL_OPTIONS_KEYS.add("sslinvalidhostnameallowed");
        GENERAL_OPTIONS_KEYS.add("tlsallowinvalidhostnames");
        GENERAL_OPTIONS_KEYS.add("proxyhost");
        GENERAL_OPTIONS_KEYS.add("proxyport");
        GENERAL_OPTIONS_KEYS.add("proxyusername");
        GENERAL_OPTIONS_KEYS.add("proxypassword");
        GENERAL_OPTIONS_KEYS.add("replicaset");
        GENERAL_OPTIONS_KEYS.add("readconcernlevel");
        GENERAL_OPTIONS_KEYS.add("serverselectiontimeoutms");
        GENERAL_OPTIONS_KEYS.add("localthresholdms");
        GENERAL_OPTIONS_KEYS.add("heartbeatfrequencyms");
        GENERAL_OPTIONS_KEYS.add("servermonitoringmode");
        GENERAL_OPTIONS_KEYS.add("retrywrites");
        GENERAL_OPTIONS_KEYS.add("retryreads");
        GENERAL_OPTIONS_KEYS.add("appname");
        GENERAL_OPTIONS_KEYS.add("uuidrepresentation");
        GENERAL_OPTIONS_KEYS.add("directconnection");
        GENERAL_OPTIONS_KEYS.add("loadbalanced");
        GENERAL_OPTIONS_KEYS.add("srvmaxhosts");
        GENERAL_OPTIONS_KEYS.add("srvservicename");
        COMPRESSOR_KEYS.add("compressors");
        COMPRESSOR_KEYS.add("zlibcompressionlevel");
        READ_PREFERENCE_KEYS.add("readpreference");
        READ_PREFERENCE_KEYS.add("readpreferencetags");
        READ_PREFERENCE_KEYS.add("maxstalenessseconds");
        WRITE_CONCERN_KEYS.add("safe");
        WRITE_CONCERN_KEYS.add("w");
        WRITE_CONCERN_KEYS.add("wtimeoutms");
        WRITE_CONCERN_KEYS.add("journal");
        AUTH_KEYS.add("authmechanism");
        AUTH_KEYS.add("authsource");
        AUTH_KEYS.add("gssapiservicename");
        AUTH_KEYS.add("authmechanismproperties");
        ALL_KEYS.addAll(GENERAL_OPTIONS_KEYS);
        ALL_KEYS.addAll(AUTH_KEYS);
        ALL_KEYS.addAll(READ_PREFERENCE_KEYS);
        ALL_KEYS.addAll(WRITE_CONCERN_KEYS);
        ALL_KEYS.addAll(COMPRESSOR_KEYS);
        TRUE_VALUES = new HashSet<String>(Arrays.asList("true", "yes", "1"));
        FALSE_VALUES = new HashSet<String>(Arrays.asList("false", "no", "0"));
    }
}

