/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.assertions.Assertions;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;

public abstract class CreateIndexCommitQuorum {
    public static final CreateIndexCommitQuorum MAJORITY = new CreateIndexCommitQuorumWithMode("majority");
    public static final CreateIndexCommitQuorum VOTING_MEMBERS = new CreateIndexCommitQuorumWithMode("votingMembers");

    public static CreateIndexCommitQuorum create(String string) {
        return new CreateIndexCommitQuorumWithMode(string);
    }

    public static CreateIndexCommitQuorum create(int n) {
        return new CreateIndexCommitQuorumWithW(n);
    }

    public abstract BsonValue toBsonValue();

    private CreateIndexCommitQuorum() {
    }

    private static final class CreateIndexCommitQuorumWithMode
    extends CreateIndexCommitQuorum {
        private final String mode;

        private CreateIndexCommitQuorumWithMode(String string) {
            Assertions.notNull("mode", string);
            this.mode = string;
        }

        public String getMode() {
            return this.mode;
        }

        @Override
        public BsonValue toBsonValue() {
            return new BsonString(this.mode);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CreateIndexCommitQuorumWithMode createIndexCommitQuorumWithMode = (CreateIndexCommitQuorumWithMode)object;
            return this.mode.equals(createIndexCommitQuorumWithMode.mode);
        }

        public int hashCode() {
            return this.mode.hashCode();
        }

        public String toString() {
            return "CreateIndexCommitQuorum{mode=" + this.mode + '}';
        }
    }

    private static final class CreateIndexCommitQuorumWithW
    extends CreateIndexCommitQuorum {
        private final int w;

        private CreateIndexCommitQuorumWithW(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("w cannot be less than zero");
            }
            this.w = n;
        }

        public int getW() {
            return this.w;
        }

        @Override
        public BsonValue toBsonValue() {
            return new BsonInt32(this.w);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CreateIndexCommitQuorumWithW createIndexCommitQuorumWithW = (CreateIndexCommitQuorumWithW)object;
            return this.w == createIndexCommitQuorumWithW.w;
        }

        public int hashCode() {
            return this.w;
        }

        public String toString() {
            return "CreateIndexCommitQuorum{w=" + this.w + '}';
        }
    }
}

