/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObjectFactory;
import com.mongodb.DBObject;
import com.mongodb.DBObjectCodecProvider;
import com.mongodb.DBObjectFactory;
import com.mongodb.DBRef;
import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSONObject;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonDbPointer;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.UuidRepresentation;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.IdGenerator;
import org.bson.codecs.ObjectIdGenerator;
import org.bson.codecs.OverridableUuidRepresentationCodec;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.CodeWScope;
import org.bson.types.Symbol;

public class DBObjectCodec
implements CollectibleCodec<DBObject>,
OverridableUuidRepresentationCodec<DBObject> {
    private static final BsonTypeClassMap DEFAULT_BSON_TYPE_CLASS_MAP = DBObjectCodec.createDefaultBsonTypeClassMap();
    private static final CodecRegistry DEFAULT_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new BsonValueCodecProvider(), new DBObjectCodecProvider()));
    private static final String ID_FIELD_NAME = "_id";
    private final CodecRegistry codecRegistry;
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final DBObjectFactory objectFactory;
    private final IdGenerator idGenerator = new ObjectIdGenerator();
    private final UuidRepresentation uuidRepresentation;

    private static BsonTypeClassMap createDefaultBsonTypeClassMap() {
        HashMap hashMap = new HashMap();
        hashMap.put(BsonType.REGULAR_EXPRESSION, Pattern.class);
        hashMap.put(BsonType.SYMBOL, String.class);
        hashMap.put(BsonType.TIMESTAMP, BSONTimestamp.class);
        hashMap.put(BsonType.JAVASCRIPT_WITH_SCOPE, null);
        hashMap.put(BsonType.DOCUMENT, null);
        return new BsonTypeClassMap(hashMap);
    }

    static BsonTypeClassMap getDefaultBsonTypeClassMap() {
        return DEFAULT_BSON_TYPE_CLASS_MAP;
    }

    static CodecRegistry getDefaultRegistry() {
        return DEFAULT_REGISTRY;
    }

    public DBObjectCodec() {
        this(DEFAULT_REGISTRY);
    }

    public DBObjectCodec(CodecRegistry codecRegistry) {
        this(codecRegistry, DEFAULT_BSON_TYPE_CLASS_MAP);
    }

    public DBObjectCodec(CodecRegistry codecRegistry, BsonTypeClassMap bsonTypeClassMap) {
        this(codecRegistry, bsonTypeClassMap, new BasicDBObjectFactory());
    }

    public DBObjectCodec(CodecRegistry codecRegistry, BsonTypeClassMap bsonTypeClassMap, DBObjectFactory dBObjectFactory) {
        this(codecRegistry, new BsonTypeCodecMap(Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap), codecRegistry), dBObjectFactory, UuidRepresentation.UNSPECIFIED);
    }

    private DBObjectCodec(CodecRegistry codecRegistry, BsonTypeCodecMap bsonTypeCodecMap, DBObjectFactory dBObjectFactory, UuidRepresentation uuidRepresentation) {
        this.objectFactory = Assertions.notNull("objectFactory", dBObjectFactory);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.uuidRepresentation = Assertions.notNull("uuidRepresentation", uuidRepresentation);
        this.bsonTypeCodecMap = bsonTypeCodecMap;
    }

    @Override
    public void encode(BsonWriter bsonWriter, DBObject dBObject, EncoderContext encoderContext) {
        bsonWriter.writeStartDocument();
        this.beforeFields(bsonWriter, encoderContext, dBObject);
        for (String string : dBObject.keySet()) {
            if (this.skipField(encoderContext, string)) continue;
            bsonWriter.writeName(string);
            this.writeValue(bsonWriter, encoderContext, dBObject.get(string));
        }
        bsonWriter.writeEndDocument();
    }

    @Override
    public DBObject decode(BsonReader bsonReader, DecoderContext decoderContext) {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        return this.readDocument(bsonReader, decoderContext, arrayList);
    }

    @Override
    public Class<DBObject> getEncoderClass() {
        return DBObject.class;
    }

    @Override
    public boolean documentHasId(DBObject dBObject) {
        return dBObject.containsField(ID_FIELD_NAME);
    }

    @Override
    public BsonValue getDocumentId(DBObject dBObject) {
        if (!this.documentHasId(dBObject)) {
            throw new IllegalStateException("The document does not contain an _id");
        }
        Object object = dBObject.get(ID_FIELD_NAME);
        if (object instanceof BsonValue) {
            return (BsonValue)object;
        }
        BsonDocument bsonDocument = new BsonDocument();
        BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(bsonDocument);
        bsonDocumentWriter.writeStartDocument();
        bsonDocumentWriter.writeName(ID_FIELD_NAME);
        this.writeValue(bsonDocumentWriter, EncoderContext.builder().build(), object);
        bsonDocumentWriter.writeEndDocument();
        return bsonDocument.get(ID_FIELD_NAME);
    }

    @Override
    public DBObject generateIdIfAbsentFromDocument(DBObject dBObject) {
        if (!this.documentHasId(dBObject)) {
            dBObject.put(ID_FIELD_NAME, this.idGenerator.generate());
        }
        return dBObject;
    }

    @Override
    public Codec<DBObject> withUuidRepresentation(UuidRepresentation uuidRepresentation) {
        if (this.uuidRepresentation.equals((Object)uuidRepresentation)) {
            return this;
        }
        return new DBObjectCodec(this.codecRegistry, this.bsonTypeCodecMap, this.objectFactory, uuidRepresentation);
    }

    private void beforeFields(BsonWriter bsonWriter, EncoderContext encoderContext, DBObject dBObject) {
        if (encoderContext.isEncodingCollectibleDocument() && dBObject.containsField(ID_FIELD_NAME)) {
            bsonWriter.writeName(ID_FIELD_NAME);
            this.writeValue(bsonWriter, encoderContext, dBObject.get(ID_FIELD_NAME));
        }
    }

    private boolean skipField(EncoderContext encoderContext, String string) {
        return encoderContext.isEncodingCollectibleDocument() && string.equals(ID_FIELD_NAME);
    }

    private void writeValue(BsonWriter bsonWriter, EncoderContext encoderContext, @Nullable Object object) {
        if (object == null) {
            bsonWriter.writeNull();
        } else if (object instanceof DBRef) {
            this.encodeDBRef(bsonWriter, (DBRef)object, encoderContext);
        } else if (object instanceof Map) {
            this.encodeMap(bsonWriter, (Map)object, encoderContext);
        } else if (object instanceof Iterable) {
            this.encodeIterable(bsonWriter, (Iterable)object, encoderContext);
        } else if (object instanceof BSONObject) {
            this.encodeBsonObject(bsonWriter, (BSONObject)object, encoderContext);
        } else if (object instanceof CodeWScope) {
            this.encodeCodeWScope(bsonWriter, (CodeWScope)object, encoderContext);
        } else if (object instanceof byte[]) {
            this.encodeByteArray(bsonWriter, (byte[])object);
        } else if (object.getClass().isArray()) {
            this.encodeArray(bsonWriter, object, encoderContext);
        } else if (object instanceof Symbol) {
            bsonWriter.writeSymbol(((Symbol)object).getSymbol());
        } else {
            Codec<?> codec = this.codecRegistry.get(object.getClass());
            encoderContext.encodeWithChildContext(codec, bsonWriter, object);
        }
    }

    private void encodeMap(BsonWriter bsonWriter, Map<String, Object> map, EncoderContext encoderContext) {
        bsonWriter.writeStartDocument();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            bsonWriter.writeName(entry.getKey());
            this.writeValue(bsonWriter, encoderContext.getChildContext(), entry.getValue());
        }
        bsonWriter.writeEndDocument();
    }

    private void encodeBsonObject(BsonWriter bsonWriter, BSONObject bSONObject, EncoderContext encoderContext) {
        bsonWriter.writeStartDocument();
        for (String string : bSONObject.keySet()) {
            bsonWriter.writeName(string);
            this.writeValue(bsonWriter, encoderContext.getChildContext(), bSONObject.get(string));
        }
        bsonWriter.writeEndDocument();
    }

    private void encodeByteArray(BsonWriter bsonWriter, byte[] byArray) {
        bsonWriter.writeBinaryData(new BsonBinary(byArray));
    }

    private void encodeArray(BsonWriter bsonWriter, Object object, EncoderContext encoderContext) {
        bsonWriter.writeStartArray();
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            this.writeValue(bsonWriter, encoderContext.getChildContext(), Array.get(object, i));
        }
        bsonWriter.writeEndArray();
    }

    private void encodeDBRef(BsonWriter bsonWriter, DBRef dBRef, EncoderContext encoderContext) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeString("$ref", dBRef.getCollectionName());
        bsonWriter.writeName("$id");
        this.writeValue(bsonWriter, encoderContext.getChildContext(), dBRef.getId());
        if (dBRef.getDatabaseName() != null) {
            bsonWriter.writeString("$db", dBRef.getDatabaseName());
        }
        bsonWriter.writeEndDocument();
    }

    private void encodeCodeWScope(BsonWriter bsonWriter, CodeWScope codeWScope, EncoderContext encoderContext) {
        bsonWriter.writeJavaScriptWithScope(codeWScope.getCode());
        this.encodeBsonObject(bsonWriter, codeWScope.getScope(), encoderContext.getChildContext());
    }

    private void encodeIterable(BsonWriter bsonWriter, Iterable iterable, EncoderContext encoderContext) {
        bsonWriter.writeStartArray();
        for (Object t : iterable) {
            this.writeValue(bsonWriter, encoderContext.getChildContext(), t);
        }
        bsonWriter.writeEndArray();
    }

    @Nullable
    private Object readValue(BsonReader bsonReader, DecoderContext decoderContext, @Nullable String string, List<String> list) {
        Object object;
        BsonType bsonType = bsonReader.getCurrentBsonType();
        if (bsonType.isContainer() && string != null) {
            list.add(string);
        }
        switch (bsonType) {
            case DOCUMENT: {
                object = this.verifyForDBRef(this.readDocument(bsonReader, decoderContext, list));
                break;
            }
            case ARRAY: {
                object = this.readArray(bsonReader, decoderContext, list);
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                object = this.readCodeWScope(bsonReader, decoderContext, list);
                break;
            }
            case DB_POINTER: {
                BsonDbPointer bsonDbPointer = bsonReader.readDBPointer();
                object = new DBRef(bsonDbPointer.getNamespace(), bsonDbPointer.getId());
                break;
            }
            case BINARY: {
                object = this.readBinary(bsonReader, decoderContext);
                break;
            }
            case NULL: {
                bsonReader.readNull();
                object = null;
                break;
            }
            default: {
                object = this.bsonTypeCodecMap.get(bsonType).decode(bsonReader, decoderContext);
            }
        }
        if (bsonType.isContainer() && string != null) {
            list.remove(string);
        }
        return object;
    }

    private Object readBinary(BsonReader bsonReader, DecoderContext decoderContext) {
        Codec<Object> codec;
        block7: {
            byte by;
            block6: {
                by = bsonReader.peekBinarySubType();
                if (!BsonBinarySubType.isUuid(by) || bsonReader.peekBinarySize() != 16) break block6;
                codec = this.codecRegistry.get(Binary.class);
                switch (by) {
                    case 3: {
                        if (this.uuidRepresentation == UuidRepresentation.JAVA_LEGACY || this.uuidRepresentation == UuidRepresentation.C_SHARP_LEGACY || this.uuidRepresentation == UuidRepresentation.PYTHON_LEGACY) {
                            codec = this.codecRegistry.get(UUID.class);
                        }
                        break block7;
                    }
                    case 4: {
                        if (this.uuidRepresentation == UuidRepresentation.STANDARD) {
                            codec = this.codecRegistry.get(UUID.class);
                        }
                        break block7;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown UUID binary subtype " + by);
                    }
                }
            }
            codec = by == BsonBinarySubType.BINARY.getValue() || by == BsonBinarySubType.OLD_BINARY.getValue() ? this.codecRegistry.get(byte[].class) : this.codecRegistry.get(Binary.class);
        }
        return codec.decode(bsonReader, decoderContext);
    }

    private List readArray(BsonReader bsonReader, DecoderContext decoderContext, List<String> list) {
        bsonReader.readStartArray();
        BasicDBList basicDBList = new BasicDBList();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            basicDBList.add(this.readValue(bsonReader, decoderContext, null, list));
        }
        bsonReader.readEndArray();
        return basicDBList;
    }

    private DBObject readDocument(BsonReader bsonReader, DecoderContext decoderContext, List<String> list) {
        DBObject dBObject = this.objectFactory.getInstance(list);
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String string = bsonReader.readName();
            dBObject.put(string, this.readValue(bsonReader, decoderContext, string, list));
        }
        bsonReader.readEndDocument();
        return dBObject;
    }

    private CodeWScope readCodeWScope(BsonReader bsonReader, DecoderContext decoderContext, List<String> list) {
        return new CodeWScope(bsonReader.readJavaScriptWithScope(), this.readDocument(bsonReader, decoderContext, list));
    }

    private Object verifyForDBRef(DBObject dBObject) {
        if (dBObject.containsField("$ref") && dBObject.containsField("$id")) {
            return new DBRef((String)dBObject.get("$db"), (String)dBObject.get("$ref"), dBObject.get("$id"));
        }
        return dBObject;
    }
}

