/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.io.Serializable;
import java.util.Objects;

public class DBRef
implements Serializable {
    private static final long serialVersionUID = -849581217713362618L;
    private final Object id;
    private final String collectionName;
    private final String databaseName;

    public DBRef(String string, Object object) {
        this(null, string, object);
    }

    public DBRef(@Nullable String string, String string2, Object object) {
        this.id = Assertions.notNull("id", object);
        this.collectionName = Assertions.notNull("collectionName", string2);
        this.databaseName = string;
    }

    public Object getId() {
        return this.id;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    @Nullable
    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DBRef dBRef = (DBRef)object;
        if (!this.id.equals(dBRef.id)) {
            return false;
        }
        if (!this.collectionName.equals(dBRef.collectionName)) {
            return false;
        }
        return Objects.equals(this.databaseName, dBRef.databaseName);
    }

    public int hashCode() {
        int n = this.id.hashCode();
        n = 31 * n + this.collectionName.hashCode();
        n = 31 * n + (this.databaseName != null ? this.databaseName.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "{ \"$ref\" : \"" + this.collectionName + "\", \"$id\" : \"" + this.id + "\"" + (this.databaseName == null ? "" : ", \"$db\" : \"" + this.databaseName + "\"") + " }";
    }
}

