/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBRef;
import com.mongodb.assertions.Assertions;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public class DBRefCodec
implements Codec<DBRef> {
    private final CodecRegistry registry;

    public DBRefCodec(CodecRegistry codecRegistry) {
        this.registry = Assertions.notNull("registry", codecRegistry);
    }

    @Override
    public void encode(BsonWriter bsonWriter, DBRef dBRef, EncoderContext encoderContext) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeString("$ref", dBRef.getCollectionName());
        bsonWriter.writeName("$id");
        Codec<?> codec = this.registry.get(dBRef.getId().getClass());
        codec.encode(bsonWriter, dBRef.getId(), encoderContext);
        if (dBRef.getDatabaseName() != null) {
            bsonWriter.writeString("$db", dBRef.getDatabaseName());
        }
        bsonWriter.writeEndDocument();
    }

    @Override
    public Class<DBRef> getEncoderClass() {
        return DBRef.class;
    }

    @Override
    public DBRef decode(BsonReader bsonReader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException("DBRefCodec does not support decoding");
    }
}

