/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.SubjectProvider;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.Locks;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

@ThreadSafe
public class KerberosSubjectProvider
implements SubjectProvider {
    private static final Logger LOGGER = Loggers.getLogger("authenticator");
    private static final String TGT_PREFIX = "krbtgt/";
    private final ReentrantLock lock = new ReentrantLock();
    private String loginContextName;
    private String fallbackLoginContextName;
    private Subject subject;

    public KerberosSubjectProvider() {
        this("com.sun.security.jgss.krb5.initiate", "com.sun.security.jgss.initiate");
    }

    public KerberosSubjectProvider(String string) {
        this(string, null);
    }

    private KerberosSubjectProvider(String string, @Nullable String string2) {
        this.loginContextName = Assertions.notNull("loginContextName", string);
        this.fallbackLoginContextName = string2;
    }

    @Override
    @NonNull
    public Subject getSubject() throws LoginException {
        return Locks.checkedWithInterruptibleLock(this.lock, () -> {
            if (this.subject == null || KerberosSubjectProvider.needNewSubject(this.subject)) {
                this.subject = this.createNewSubject();
            }
            return this.subject;
        });
    }

    private Subject createNewSubject() throws LoginException {
        LoginContext loginContext;
        try {
            LOGGER.debug(String.format("Creating LoginContext with name '%s'", this.loginContextName));
            loginContext = new LoginContext(this.loginContextName);
        }
        catch (LoginException loginException) {
            if (this.fallbackLoginContextName == null) {
                throw loginException;
            }
            LOGGER.debug(String.format("Creating LoginContext with fallback name '%s'", this.fallbackLoginContextName));
            loginContext = new LoginContext(this.fallbackLoginContextName);
            this.loginContextName = this.fallbackLoginContextName;
            this.fallbackLoginContextName = null;
        }
        loginContext.login();
        LOGGER.debug("Login successful");
        return loginContext.getSubject();
    }

    private static boolean needNewSubject(Subject subject) {
        for (KerberosTicket kerberosTicket : subject.getPrivateCredentials(KerberosTicket.class)) {
            if (!kerberosTicket.getServer().getName().startsWith(TGT_PREFIX)) continue;
            if (System.currentTimeMillis() <= kerberosTicket.getEndTime().getTime() - TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES)) break;
            LOGGER.info("The TGT is close to expiring. Time to reacquire.");
            return true;
        }
        return false;
    }
}

