/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import java.util.Objects;

@Immutable
public final class LoggerSettings {
    private final int maxDocumentLength;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LoggerSettings loggerSettings) {
        return LoggerSettings.builder().applySettings(loggerSettings);
    }

    public int getMaxDocumentLength() {
        return this.maxDocumentLength;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LoggerSettings loggerSettings = (LoggerSettings)object;
        return this.maxDocumentLength == loggerSettings.maxDocumentLength;
    }

    public int hashCode() {
        return Objects.hash(this.maxDocumentLength);
    }

    public String toString() {
        return "LoggerSettings{maxDocumentLength=" + this.maxDocumentLength + '}';
    }

    private LoggerSettings(Builder builder) {
        this.maxDocumentLength = builder.maxDocumentLength;
    }

    public static final class Builder {
        private int maxDocumentLength = 1000;

        private Builder() {
        }

        public Builder applySettings(LoggerSettings loggerSettings) {
            Assertions.notNull("loggerSettings", loggerSettings);
            this.maxDocumentLength = loggerSettings.maxDocumentLength;
            return this;
        }

        public Builder maxDocumentLength(int n) {
            this.maxDocumentLength = n;
            return this;
        }

        public LoggerSettings build() {
            return new LoggerSettings(this);
        }
    }
}

