/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoServerException;
import com.mongodb.ServerAddress;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class MongoBulkWriteException
extends MongoServerException {
    private static final long serialVersionUID = -4345399805987210275L;
    private final BulkWriteResult writeResult;
    private final List<BulkWriteError> errors;
    private final ServerAddress serverAddress;
    private final WriteConcernError writeConcernError;

    public MongoBulkWriteException(BulkWriteResult bulkWriteResult, List<BulkWriteError> list, @Nullable WriteConcernError writeConcernError, ServerAddress serverAddress, Set<String> set) {
        super("Bulk write operation error on server " + serverAddress + ". " + (list.isEmpty() ? "" : "Write errors: " + list + ". ") + (writeConcernError == null ? "" : "Write concern error: " + writeConcernError + ". "), serverAddress);
        this.writeResult = bulkWriteResult;
        this.errors = list;
        this.writeConcernError = writeConcernError;
        this.serverAddress = serverAddress;
        this.addLabels(set);
    }

    public BulkWriteResult getWriteResult() {
        return this.writeResult;
    }

    public List<BulkWriteError> getWriteErrors() {
        return this.errors;
    }

    @Nullable
    public WriteConcernError getWriteConcernError() {
        return this.writeConcernError;
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MongoBulkWriteException mongoBulkWriteException = (MongoBulkWriteException)object;
        if (!this.errors.equals(mongoBulkWriteException.errors)) {
            return false;
        }
        if (!this.serverAddress.equals(mongoBulkWriteException.serverAddress)) {
            return false;
        }
        if (!Objects.equals(this.writeConcernError, mongoBulkWriteException.writeConcernError)) {
            return false;
        }
        return this.writeResult.equals(mongoBulkWriteException.writeResult);
    }

    public int hashCode() {
        int n = this.writeResult.hashCode();
        n = 31 * n + this.errors.hashCode();
        n = 31 * n + this.serverAddress.hashCode();
        n = 31 * n + (this.writeConcernError != null ? this.writeConcernError.hashCode() : 0);
        return n;
    }
}

