/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.Block;
import com.mongodb.ConnectionString;
import com.mongodb.ContextProvider;
import com.mongodb.DBObjectCodecProvider;
import com.mongodb.DBRefCodecProvider;
import com.mongodb.DocumentToDBRefTransformer;
import com.mongodb.Jep395RecordCodecProvider;
import com.mongodb.KotlinCodecProvider;
import com.mongodb.LoggerSettings;
import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerApi;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.Alpha;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.annotations.Reason;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.gridfs.codecs.GridFSFileCodecProvider;
import com.mongodb.client.model.geojson.codecs.GeoJsonCodecProvider;
import com.mongodb.client.model.mql.ExpressionCodecProvider;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.TransportSettings;
import com.mongodb.event.CommandListener;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.lang.Nullable;
import com.mongodb.spi.dns.DnsClient;
import com.mongodb.spi.dns.InetAddressResolver;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bson.UuidRepresentation;
import org.bson.codecs.BsonCodecProvider;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.CollectionCodecProvider;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.EnumCodecProvider;
import org.bson.codecs.IterableCodecProvider;
import org.bson.codecs.JsonObjectCodecProvider;
import org.bson.codecs.MapCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.jsr310.Jsr310CodecProvider;

@Immutable
public final class MongoClientSettings {
    private static final CodecRegistry DEFAULT_CODEC_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new BsonValueCodecProvider(), new DBRefCodecProvider(), new DBObjectCodecProvider(), new DocumentCodecProvider(new DocumentToDBRefTransformer()), new CollectionCodecProvider(new DocumentToDBRefTransformer()), new IterableCodecProvider(new DocumentToDBRefTransformer()), new MapCodecProvider(new DocumentToDBRefTransformer()), new GeoJsonCodecProvider(), new GridFSFileCodecProvider(), new Jsr310CodecProvider(), new JsonObjectCodecProvider(), new BsonCodecProvider(), new EnumCodecProvider(), new ExpressionCodecProvider(), new Jep395RecordCodecProvider(), new KotlinCodecProvider()));
    private final ReadPreference readPreference;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final boolean retryReads;
    private final ReadConcern readConcern;
    private final MongoCredential credential;
    private final TransportSettings transportSettings;
    private final List<CommandListener> commandListeners;
    private final CodecRegistry codecRegistry;
    private final LoggerSettings loggerSettings;
    private final ClusterSettings clusterSettings;
    private final SocketSettings socketSettings;
    private final SocketSettings heartbeatSocketSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final ServerSettings serverSettings;
    private final SslSettings sslSettings;
    private final String applicationName;
    private final List<MongoCompressor> compressorList;
    private final UuidRepresentation uuidRepresentation;
    private final ServerApi serverApi;
    private final AutoEncryptionSettings autoEncryptionSettings;
    private final boolean heartbeatSocketTimeoutSetExplicitly;
    private final boolean heartbeatConnectTimeoutSetExplicitly;
    private final ContextProvider contextProvider;
    private final DnsClient dnsClient;
    private final InetAddressResolver inetAddressResolver;
    @Nullable
    private final Long timeoutMS;

    public static CodecRegistry getDefaultCodecRegistry() {
        return DEFAULT_CODEC_REGISTRY;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MongoClientSettings mongoClientSettings) {
        return new Builder(mongoClientSettings);
    }

    @Nullable
    public DnsClient getDnsClient() {
        return this.dnsClient;
    }

    @Nullable
    public InetAddressResolver getInetAddressResolver() {
        return this.inetAddressResolver;
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Nullable
    public MongoCredential getCredential() {
        return this.credential;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean getRetryWrites() {
        return this.retryWrites;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Nullable
    public TransportSettings getTransportSettings() {
        return this.transportSettings;
    }

    public List<CommandListener> getCommandListeners() {
        return Collections.unmodifiableList(this.commandListeners);
    }

    @Nullable
    public String getApplicationName() {
        return this.applicationName;
    }

    public List<MongoCompressor> getCompressorList() {
        return Collections.unmodifiableList(this.compressorList);
    }

    public UuidRepresentation getUuidRepresentation() {
        return this.uuidRepresentation;
    }

    @Nullable
    public ServerApi getServerApi() {
        return this.serverApi;
    }

    @Nullable
    @Alpha(value={Reason.CLIENT})
    public Long getTimeout(TimeUnit timeUnit) {
        return this.timeoutMS == null ? null : Long.valueOf(timeUnit.convert(this.timeoutMS, TimeUnit.MILLISECONDS));
    }

    @Nullable
    public AutoEncryptionSettings getAutoEncryptionSettings() {
        return this.autoEncryptionSettings;
    }

    public LoggerSettings getLoggerSettings() {
        return this.loggerSettings;
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public SslSettings getSslSettings() {
        return this.sslSettings;
    }

    public SocketSettings getSocketSettings() {
        return this.socketSettings;
    }

    public SocketSettings getHeartbeatSocketSettings() {
        return this.heartbeatSocketSettings;
    }

    public ConnectionPoolSettings getConnectionPoolSettings() {
        return this.connectionPoolSettings;
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    @Nullable
    public ContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MongoClientSettings mongoClientSettings = (MongoClientSettings)object;
        return this.retryWrites == mongoClientSettings.retryWrites && this.retryReads == mongoClientSettings.retryReads && this.heartbeatSocketTimeoutSetExplicitly == mongoClientSettings.heartbeatSocketTimeoutSetExplicitly && this.heartbeatConnectTimeoutSetExplicitly == mongoClientSettings.heartbeatConnectTimeoutSetExplicitly && Objects.equals(this.readPreference, mongoClientSettings.readPreference) && Objects.equals(this.writeConcern, mongoClientSettings.writeConcern) && Objects.equals(this.readConcern, mongoClientSettings.readConcern) && Objects.equals(this.credential, mongoClientSettings.credential) && Objects.equals(this.transportSettings, mongoClientSettings.transportSettings) && Objects.equals(this.commandListeners, mongoClientSettings.commandListeners) && Objects.equals(this.codecRegistry, mongoClientSettings.codecRegistry) && Objects.equals(this.loggerSettings, mongoClientSettings.loggerSettings) && Objects.equals(this.clusterSettings, mongoClientSettings.clusterSettings) && Objects.equals(this.socketSettings, mongoClientSettings.socketSettings) && Objects.equals(this.heartbeatSocketSettings, mongoClientSettings.heartbeatSocketSettings) && Objects.equals(this.connectionPoolSettings, mongoClientSettings.connectionPoolSettings) && Objects.equals(this.serverSettings, mongoClientSettings.serverSettings) && Objects.equals(this.sslSettings, mongoClientSettings.sslSettings) && Objects.equals(this.applicationName, mongoClientSettings.applicationName) && Objects.equals(this.compressorList, mongoClientSettings.compressorList) && this.uuidRepresentation == mongoClientSettings.uuidRepresentation && Objects.equals(this.serverApi, mongoClientSettings.serverApi) && Objects.equals(this.autoEncryptionSettings, mongoClientSettings.autoEncryptionSettings) && Objects.equals(this.dnsClient, mongoClientSettings.dnsClient) && Objects.equals(this.inetAddressResolver, mongoClientSettings.inetAddressResolver) && Objects.equals(this.contextProvider, mongoClientSettings.contextProvider) && Objects.equals(this.timeoutMS, mongoClientSettings.timeoutMS);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.credential, this.transportSettings, this.commandListeners, this.codecRegistry, this.loggerSettings, this.clusterSettings, this.socketSettings, this.heartbeatSocketSettings, this.connectionPoolSettings, this.serverSettings, this.sslSettings, this.applicationName, this.compressorList, this.uuidRepresentation, this.serverApi, this.autoEncryptionSettings, this.heartbeatSocketTimeoutSetExplicitly, this.heartbeatConnectTimeoutSetExplicitly, this.dnsClient, this.inetAddressResolver, this.contextProvider, this.timeoutMS});
    }

    public String toString() {
        return "MongoClientSettings{readPreference=" + this.readPreference + ", writeConcern=" + this.writeConcern + ", retryWrites=" + this.retryWrites + ", retryReads=" + this.retryReads + ", readConcern=" + this.readConcern + ", credential=" + this.credential + ", transportSettings=" + this.transportSettings + ", commandListeners=" + this.commandListeners + ", codecRegistry=" + this.codecRegistry + ", loggerSettings=" + this.loggerSettings + ", clusterSettings=" + this.clusterSettings + ", socketSettings=" + this.socketSettings + ", heartbeatSocketSettings=" + this.heartbeatSocketSettings + ", connectionPoolSettings=" + this.connectionPoolSettings + ", serverSettings=" + this.serverSettings + ", sslSettings=" + this.sslSettings + ", applicationName='" + this.applicationName + '\'' + ", compressorList=" + this.compressorList + ", uuidRepresentation=" + (Object)((Object)this.uuidRepresentation) + ", serverApi=" + this.serverApi + ", autoEncryptionSettings=" + this.autoEncryptionSettings + ", dnsClient=" + this.dnsClient + ", inetAddressResolver=" + this.inetAddressResolver + ", contextProvider=" + this.contextProvider + ", timeoutMS=" + this.timeoutMS + '}';
    }

    private MongoClientSettings(Builder builder2) {
        Assertions.isTrue("timeoutMS > 0 ", builder2.timeoutMS == null || builder2.timeoutMS >= 0L);
        this.readPreference = builder2.readPreference;
        this.writeConcern = builder2.writeConcern;
        this.retryWrites = builder2.retryWrites;
        this.retryReads = builder2.retryReads;
        this.readConcern = builder2.readConcern;
        this.credential = builder2.credential;
        this.transportSettings = builder2.transportSettings;
        this.codecRegistry = builder2.codecRegistry;
        this.commandListeners = builder2.commandListeners;
        this.applicationName = builder2.applicationName;
        this.loggerSettings = builder2.loggerSettingsBuilder.build();
        this.clusterSettings = builder2.clusterSettingsBuilder.build();
        this.serverSettings = builder2.serverSettingsBuilder.build();
        this.socketSettings = builder2.socketSettingsBuilder.build();
        this.connectionPoolSettings = builder2.connectionPoolSettingsBuilder.build();
        this.sslSettings = builder2.sslSettingsBuilder.build();
        this.compressorList = builder2.compressorList;
        this.uuidRepresentation = builder2.uuidRepresentation;
        this.serverApi = builder2.serverApi;
        this.dnsClient = builder2.dnsClient;
        this.inetAddressResolver = builder2.inetAddressResolver;
        this.autoEncryptionSettings = builder2.autoEncryptionSettings;
        this.heartbeatSocketSettings = SocketSettings.builder().readTimeout(builder2.heartbeatSocketTimeoutMS == 0 ? (long)this.socketSettings.getConnectTimeout(TimeUnit.MILLISECONDS) : (long)builder2.heartbeatSocketTimeoutMS, TimeUnit.MILLISECONDS).connectTimeout(builder2.heartbeatConnectTimeoutMS == 0 ? (long)this.socketSettings.getConnectTimeout(TimeUnit.MILLISECONDS) : (long)builder2.heartbeatConnectTimeoutMS, TimeUnit.MILLISECONDS).applyToProxySettings(builder -> builder.applySettings(this.socketSettings.getProxySettings())).build();
        this.heartbeatSocketTimeoutSetExplicitly = builder2.heartbeatSocketTimeoutMS != 0;
        this.heartbeatConnectTimeoutSetExplicitly = builder2.heartbeatConnectTimeoutMS != 0;
        this.contextProvider = builder2.contextProvider;
        this.timeoutMS = builder2.timeoutMS;
    }

    @NotThreadSafe
    public static final class Builder {
        private ReadPreference readPreference = ReadPreference.primary();
        private WriteConcern writeConcern = WriteConcern.ACKNOWLEDGED;
        private boolean retryWrites = true;
        private boolean retryReads = true;
        private ReadConcern readConcern = ReadConcern.DEFAULT;
        private CodecRegistry codecRegistry = MongoClientSettings.getDefaultCodecRegistry();
        private TransportSettings transportSettings;
        private List<CommandListener> commandListeners = new ArrayList<CommandListener>();
        private final LoggerSettings.Builder loggerSettingsBuilder = LoggerSettings.builder();
        private final ClusterSettings.Builder clusterSettingsBuilder = ClusterSettings.builder();
        private final SocketSettings.Builder socketSettingsBuilder = SocketSettings.builder();
        private final ConnectionPoolSettings.Builder connectionPoolSettingsBuilder = ConnectionPoolSettings.builder();
        private final ServerSettings.Builder serverSettingsBuilder = ServerSettings.builder();
        private final SslSettings.Builder sslSettingsBuilder = SslSettings.builder();
        private MongoCredential credential;
        private String applicationName;
        private List<MongoCompressor> compressorList = Collections.emptyList();
        private UuidRepresentation uuidRepresentation = UuidRepresentation.UNSPECIFIED;
        private ServerApi serverApi;
        private AutoEncryptionSettings autoEncryptionSettings;
        private int heartbeatConnectTimeoutMS;
        private int heartbeatSocketTimeoutMS;
        private Long timeoutMS;
        private ContextProvider contextProvider;
        private DnsClient dnsClient;
        private InetAddressResolver inetAddressResolver;

        private Builder() {
        }

        private Builder(MongoClientSettings mongoClientSettings) {
            Assertions.notNull("settings", mongoClientSettings);
            this.applicationName = mongoClientSettings.getApplicationName();
            this.commandListeners = new ArrayList<CommandListener>(mongoClientSettings.getCommandListeners());
            this.compressorList = new ArrayList<MongoCompressor>(mongoClientSettings.getCompressorList());
            this.codecRegistry = mongoClientSettings.getCodecRegistry();
            this.readPreference = mongoClientSettings.getReadPreference();
            this.writeConcern = mongoClientSettings.getWriteConcern();
            this.retryWrites = mongoClientSettings.getRetryWrites();
            this.retryReads = mongoClientSettings.getRetryReads();
            this.readConcern = mongoClientSettings.getReadConcern();
            this.credential = mongoClientSettings.getCredential();
            this.uuidRepresentation = mongoClientSettings.getUuidRepresentation();
            this.serverApi = mongoClientSettings.getServerApi();
            this.dnsClient = mongoClientSettings.getDnsClient();
            this.timeoutMS = mongoClientSettings.getTimeout(TimeUnit.MILLISECONDS);
            this.inetAddressResolver = mongoClientSettings.getInetAddressResolver();
            this.transportSettings = mongoClientSettings.getTransportSettings();
            this.autoEncryptionSettings = mongoClientSettings.getAutoEncryptionSettings();
            this.contextProvider = mongoClientSettings.getContextProvider();
            this.loggerSettingsBuilder.applySettings(mongoClientSettings.getLoggerSettings());
            this.clusterSettingsBuilder.applySettings(mongoClientSettings.getClusterSettings());
            this.serverSettingsBuilder.applySettings(mongoClientSettings.getServerSettings());
            this.socketSettingsBuilder.applySettings(mongoClientSettings.getSocketSettings());
            this.connectionPoolSettingsBuilder.applySettings(mongoClientSettings.getConnectionPoolSettings());
            this.sslSettingsBuilder.applySettings(mongoClientSettings.getSslSettings());
            if (mongoClientSettings.heartbeatConnectTimeoutSetExplicitly) {
                this.heartbeatConnectTimeoutMS = mongoClientSettings.heartbeatSocketSettings.getConnectTimeout(TimeUnit.MILLISECONDS);
            }
            if (mongoClientSettings.heartbeatSocketTimeoutSetExplicitly) {
                this.heartbeatSocketTimeoutMS = mongoClientSettings.heartbeatSocketSettings.getReadTimeout(TimeUnit.MILLISECONDS);
            }
        }

        public Builder applyConnectionString(ConnectionString connectionString) {
            Boolean bl;
            Boolean bl2;
            if (connectionString.getApplicationName() != null) {
                this.applicationName = connectionString.getApplicationName();
            }
            this.clusterSettingsBuilder.applyConnectionString(connectionString);
            if (!connectionString.getCompressorList().isEmpty()) {
                this.compressorList = connectionString.getCompressorList();
            }
            this.connectionPoolSettingsBuilder.applyConnectionString(connectionString);
            if (connectionString.getCredential() != null) {
                this.credential = connectionString.getCredential();
            }
            if (connectionString.getReadConcern() != null) {
                this.readConcern = connectionString.getReadConcern();
            }
            if (connectionString.getReadPreference() != null) {
                this.readPreference = connectionString.getReadPreference();
            }
            if ((bl2 = connectionString.getRetryWritesValue()) != null) {
                this.retryWrites = bl2;
            }
            if ((bl = connectionString.getRetryReads()) != null) {
                this.retryReads = bl;
            }
            if (connectionString.getUuidRepresentation() != null) {
                this.uuidRepresentation = connectionString.getUuidRepresentation();
            }
            this.serverSettingsBuilder.applyConnectionString(connectionString);
            this.socketSettingsBuilder.applyConnectionString(connectionString);
            this.sslSettingsBuilder.applyConnectionString(connectionString);
            if (connectionString.getWriteConcern() != null) {
                this.writeConcern = connectionString.getWriteConcern();
            }
            if (connectionString.getTimeout() != null) {
                this.timeoutMS = connectionString.getTimeout();
            }
            return this;
        }

        public Builder applyToLoggerSettings(Block<LoggerSettings.Builder> block) {
            Assertions.notNull("block", block).apply(this.loggerSettingsBuilder);
            return this;
        }

        public Builder applyToClusterSettings(Block<ClusterSettings.Builder> block) {
            Assertions.notNull("block", block).apply(this.clusterSettingsBuilder);
            return this;
        }

        public Builder applyToSocketSettings(Block<SocketSettings.Builder> block) {
            Assertions.notNull("block", block).apply(this.socketSettingsBuilder);
            return this;
        }

        public Builder applyToConnectionPoolSettings(Block<ConnectionPoolSettings.Builder> block) {
            Assertions.notNull("block", block).apply(this.connectionPoolSettingsBuilder);
            return this;
        }

        public Builder applyToServerSettings(Block<ServerSettings.Builder> block) {
            Assertions.notNull("block", block).apply(this.serverSettingsBuilder);
            return this;
        }

        public Builder applyToSslSettings(Block<SslSettings.Builder> block) {
            Assertions.notNull("block", block).apply(this.sslSettingsBuilder);
            return this;
        }

        public Builder readPreference(ReadPreference readPreference) {
            this.readPreference = Assertions.notNull("readPreference", readPreference);
            return this;
        }

        public Builder writeConcern(WriteConcern writeConcern) {
            this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
            return this;
        }

        public Builder retryWrites(boolean bl) {
            this.retryWrites = bl;
            return this;
        }

        public Builder retryReads(boolean bl) {
            this.retryReads = bl;
            return this;
        }

        public Builder readConcern(ReadConcern readConcern) {
            this.readConcern = Assertions.notNull("readConcern", readConcern);
            return this;
        }

        public Builder credential(MongoCredential mongoCredential) {
            this.credential = Assertions.notNull("credential", mongoCredential);
            return this;
        }

        public Builder codecRegistry(CodecRegistry codecRegistry) {
            this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
            return this;
        }

        public Builder transportSettings(TransportSettings transportSettings) {
            this.transportSettings = Assertions.notNull("transportSettings", transportSettings);
            return this;
        }

        public Builder addCommandListener(CommandListener commandListener) {
            Assertions.notNull("commandListener", commandListener);
            this.commandListeners.add(commandListener);
            return this;
        }

        public Builder commandListenerList(List<CommandListener> list) {
            Assertions.notNull("commandListeners", list);
            this.commandListeners = new ArrayList<CommandListener>(list);
            return this;
        }

        public Builder applicationName(@Nullable String string) {
            if (string != null) {
                Assertions.isTrueArgument("applicationName UTF-8 encoding length <= 128", string.getBytes(StandardCharsets.UTF_8).length <= 128);
            }
            this.applicationName = string;
            return this;
        }

        public Builder compressorList(List<MongoCompressor> list) {
            Assertions.notNull("compressorList", list);
            this.compressorList = new ArrayList<MongoCompressor>(list);
            return this;
        }

        public Builder uuidRepresentation(UuidRepresentation uuidRepresentation) {
            this.uuidRepresentation = Assertions.notNull("uuidRepresentation", uuidRepresentation);
            return this;
        }

        public Builder serverApi(ServerApi serverApi) {
            this.serverApi = Assertions.notNull("serverApi", serverApi);
            return this;
        }

        public Builder autoEncryptionSettings(@Nullable AutoEncryptionSettings autoEncryptionSettings) {
            this.autoEncryptionSettings = autoEncryptionSettings;
            return this;
        }

        public Builder contextProvider(@Nullable ContextProvider contextProvider) {
            this.contextProvider = contextProvider;
            return this;
        }

        public Builder dnsClient(@Nullable DnsClient dnsClient) {
            this.dnsClient = dnsClient;
            return this;
        }

        public Builder inetAddressResolver(@Nullable InetAddressResolver inetAddressResolver) {
            this.inetAddressResolver = inetAddressResolver;
            return this;
        }

        @Alpha(value={Reason.CLIENT})
        public Builder timeout(long l, TimeUnit timeUnit) {
            this.timeoutMS = TimeoutSettings.convertAndValidateTimeout(l, timeUnit);
            return this;
        }

        Builder heartbeatConnectTimeoutMS(int n) {
            this.heartbeatConnectTimeoutMS = n;
            return this;
        }

        Builder heartbeatSocketTimeoutMS(int n) {
            this.heartbeatSocketTimeoutMS = n;
            return this;
        }

        public MongoClientSettings build() {
            return new MongoClientSettings(this);
        }
    }
}

