/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoInternalException;
import com.mongodb.MongoServerException;
import com.mongodb.ServerAddress;
import com.mongodb.internal.ExceptionUtils;
import java.io.StringWriter;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonWriter;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.json.JsonWriter;

public class MongoCommandException
extends MongoServerException {
    private static final long serialVersionUID = 8160676451944215078L;
    private final BsonDocument response;

    public MongoCommandException(BsonDocument bsonDocument, ServerAddress serverAddress) {
        super(ExceptionUtils.MongoCommandExceptionUtils.extractErrorCode(bsonDocument), ExceptionUtils.MongoCommandExceptionUtils.extractErrorCodeName(bsonDocument), String.format("Command failed with error %s: '%s' on server %s. The full response is %s", MongoCommandException.extractErrorCodeAndName(bsonDocument), MongoCommandException.extractErrorMessage(bsonDocument), serverAddress, MongoCommandException.getResponseAsJson(bsonDocument)), serverAddress);
        this.response = bsonDocument;
        this.addLabels(ExceptionUtils.MongoCommandExceptionUtils.extractErrorLabelsAsBson(bsonDocument));
    }

    public int getErrorCode() {
        return this.getCode();
    }

    @Override
    public String getErrorCodeName() {
        return super.getErrorCodeName();
    }

    public String getErrorMessage() {
        return MongoCommandException.extractErrorMessage(this.response);
    }

    public BsonDocument getResponse() {
        return this.response;
    }

    private static String getResponseAsJson(BsonDocument bsonDocument) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter(stringWriter);
        new BsonDocumentCodec().encode((BsonWriter)jsonWriter, bsonDocument, EncoderContext.builder().build());
        return stringWriter.toString();
    }

    private static String extractErrorCodeAndName(BsonDocument bsonDocument) {
        int n = ExceptionUtils.MongoCommandExceptionUtils.extractErrorCode(bsonDocument);
        String string = ExceptionUtils.MongoCommandExceptionUtils.extractErrorCodeName(bsonDocument);
        if (string.isEmpty()) {
            return Integer.toString(n);
        }
        return String.format("%d (%s)", n, string);
    }

    private static String extractErrorMessage(BsonDocument bsonDocument) {
        String string = bsonDocument.getString("errmsg", new BsonString("")).getValue();
        if (string == null) {
            throw new MongoInternalException("This value should not be null");
        }
        return string;
    }
}

