/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MongoCompressor {
    public static final String LEVEL = "LEVEL";
    private final String name;
    private final Map<String, Object> properties;

    public static MongoCompressor createSnappyCompressor() {
        return new MongoCompressor("snappy");
    }

    public static MongoCompressor createZlibCompressor() {
        return new MongoCompressor("zlib");
    }

    public static MongoCompressor createZstdCompressor() {
        return new MongoCompressor("zstd");
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public <T> T getProperty(String string, T t) {
        Assertions.notNull("key", string);
        Object object = this.properties.get(string.toLowerCase());
        return (T)(object == null && !this.properties.containsKey(string) ? t : object);
    }

    public <T> T getPropertyNonNull(String string, T t) {
        T t2 = this.getProperty(string, t);
        if (t2 == null) {
            throw new IllegalArgumentException();
        }
        return t2;
    }

    public <T> MongoCompressor withProperty(String string, T t) {
        return new MongoCompressor(this, string, t);
    }

    private MongoCompressor(String string) {
        this.name = string;
        this.properties = Collections.emptyMap();
    }

    private <T> MongoCompressor(MongoCompressor mongoCompressor, String string, T t) {
        Assertions.notNull("propertyKey", string);
        this.name = mongoCompressor.name;
        this.properties = new HashMap<String, Object>(mongoCompressor.properties);
        this.properties.put(string.toLowerCase(), t);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MongoCompressor mongoCompressor = (MongoCompressor)object;
        if (!this.name.equals(mongoCompressor.name)) {
            return false;
        }
        return this.properties.equals(mongoCompressor.properties);
    }

    public int hashCode() {
        int n = this.name.hashCode();
        n = 31 * n + this.properties.hashCode();
        return n;
    }

    public String toString() {
        return "MongoCompressor{name='" + this.name + '\'' + ", properties=" + this.properties + '}';
    }
}

