/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Evolving;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.Reason;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.connection.OidcAuthenticator;
import com.mongodb.lang.Nullable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Immutable
public final class MongoCredential {
    private final AuthenticationMechanism mechanism;
    private final String userName;
    private final String source;
    private final char[] password;
    private final Map<String, Object> mechanismProperties;
    public static final String GSSAPI_MECHANISM = AuthenticationMechanism.GSSAPI.getMechanismName();
    public static final String PLAIN_MECHANISM = AuthenticationMechanism.PLAIN.getMechanismName();
    public static final String MONGODB_X509_MECHANISM = AuthenticationMechanism.MONGODB_X509.getMechanismName();
    public static final String SCRAM_SHA_1_MECHANISM = AuthenticationMechanism.SCRAM_SHA_1.getMechanismName();
    public static final String SCRAM_SHA_256_MECHANISM = AuthenticationMechanism.SCRAM_SHA_256.getMechanismName();
    public static final String SERVICE_NAME_KEY = "SERVICE_NAME";
    public static final String CANONICALIZE_HOST_NAME_KEY = "CANONICALIZE_HOST_NAME";
    public static final String JAVA_SASL_CLIENT_PROPERTIES_KEY = "JAVA_SASL_CLIENT_PROPERTIES";
    public static final String JAVA_SUBJECT_PROVIDER_KEY = "JAVA_SUBJECT_PROVIDER";
    public static final String JAVA_SUBJECT_KEY = "JAVA_SUBJECT";
    public static final String AWS_SESSION_TOKEN_KEY = "AWS_SESSION_TOKEN";
    @Beta(value={Reason.CLIENT})
    public static final String AWS_CREDENTIAL_PROVIDER_KEY = "AWS_CREDENTIAL_PROVIDER";
    public static final String ENVIRONMENT_KEY = "ENVIRONMENT";
    public static final String OIDC_CALLBACK_KEY = "OIDC_CALLBACK";
    public static final String OIDC_HUMAN_CALLBACK_KEY = "OIDC_HUMAN_CALLBACK";
    public static final String ALLOWED_HOSTS_KEY = "ALLOWED_HOSTS";
    public static final List<String> DEFAULT_ALLOWED_HOSTS = Collections.unmodifiableList(Arrays.asList("*.mongodb.net", "*.mongodb-qa.net", "*.mongodb-dev.net", "*.mongodbgov.net", "localhost", "127.0.0.1", "::1"));
    public static final String TOKEN_RESOURCE_KEY = "TOKEN_RESOURCE";

    public static MongoCredential createCredential(String string, String string2, char[] cArray) {
        return new MongoCredential(null, string, string2, cArray);
    }

    public static MongoCredential createScramSha1Credential(String string, String string2, char[] cArray) {
        return new MongoCredential(AuthenticationMechanism.SCRAM_SHA_1, string, string2, cArray);
    }

    public static MongoCredential createScramSha256Credential(String string, String string2, char[] cArray) {
        return new MongoCredential(AuthenticationMechanism.SCRAM_SHA_256, string, string2, cArray);
    }

    public static MongoCredential createMongoX509Credential(String string) {
        return new MongoCredential(AuthenticationMechanism.MONGODB_X509, string, "$external", null);
    }

    public static MongoCredential createMongoX509Credential() {
        return new MongoCredential(AuthenticationMechanism.MONGODB_X509, null, "$external", null);
    }

    public static MongoCredential createPlainCredential(String string, String string2, char[] cArray) {
        return new MongoCredential(AuthenticationMechanism.PLAIN, string, string2, cArray);
    }

    public static MongoCredential createGSSAPICredential(String string) {
        return new MongoCredential(AuthenticationMechanism.GSSAPI, string, "$external", null);
    }

    public static MongoCredential createAwsCredential(@Nullable String string, @Nullable char[] cArray) {
        return new MongoCredential(AuthenticationMechanism.MONGODB_AWS, string, "$external", cArray);
    }

    public static MongoCredential createOidcCredential(@Nullable String string) {
        return new MongoCredential(AuthenticationMechanism.MONGODB_OIDC, string, "$external", null);
    }

    public <T> MongoCredential withMechanismProperty(String string, T t) {
        return new MongoCredential(this, string, t);
    }

    public MongoCredential withMechanism(AuthenticationMechanism authenticationMechanism) {
        if (this.mechanism != null) {
            throw new IllegalArgumentException("Mechanism already set");
        }
        return new MongoCredential(authenticationMechanism, this.userName, this.source, this.password, this.mechanismProperties);
    }

    MongoCredential(@Nullable AuthenticationMechanism authenticationMechanism, @Nullable String string, String string2, @Nullable char[] cArray) {
        this(authenticationMechanism, string, string2, cArray, Collections.emptyMap());
    }

    MongoCredential(@Nullable AuthenticationMechanism authenticationMechanism, @Nullable String string, String string2, @Nullable char[] cArray, Map<String, Object> map) {
        if (authenticationMechanism == AuthenticationMechanism.MONGODB_OIDC) {
            OidcAuthenticator.OidcValidator.validateOidcCredentialConstruction(string2, map);
            OidcAuthenticator.OidcValidator.validateCreateOidcCredential(cArray);
        }
        if (string == null && !Arrays.asList(AuthenticationMechanism.MONGODB_X509, AuthenticationMechanism.MONGODB_AWS, AuthenticationMechanism.MONGODB_OIDC).contains((Object)authenticationMechanism)) {
            throw new IllegalArgumentException("username can not be null");
        }
        if (authenticationMechanism == null && cArray == null) {
            throw new IllegalArgumentException("Password can not be null when the authentication mechanism is unspecified");
        }
        if (this.mechanismRequiresPassword(authenticationMechanism) && cArray == null) {
            throw new IllegalArgumentException("Password can not be null for " + (Object)((Object)authenticationMechanism) + " mechanism");
        }
        if ((authenticationMechanism == AuthenticationMechanism.GSSAPI || authenticationMechanism == AuthenticationMechanism.MONGODB_X509) && cArray != null) {
            throw new IllegalArgumentException("Password must be null for the " + (Object)((Object)authenticationMechanism) + " mechanism");
        }
        if (authenticationMechanism == AuthenticationMechanism.MONGODB_AWS && string != null && cArray == null) {
            throw new IllegalArgumentException("Password can not be null when username is provided for " + (Object)((Object)authenticationMechanism) + " mechanism");
        }
        this.mechanism = authenticationMechanism;
        this.userName = string;
        this.source = Assertions.notNull("source", string2);
        this.password = cArray != null ? (char[])cArray.clone() : null;
        this.mechanismProperties = new HashMap<String, Object>(map);
    }

    private boolean mechanismRequiresPassword(@Nullable AuthenticationMechanism authenticationMechanism) {
        return authenticationMechanism == AuthenticationMechanism.PLAIN || authenticationMechanism == AuthenticationMechanism.SCRAM_SHA_1 || authenticationMechanism == AuthenticationMechanism.SCRAM_SHA_256;
    }

    <T> MongoCredential(MongoCredential mongoCredential, String string, T t) {
        this(mongoCredential.mechanism, mongoCredential.userName, mongoCredential.source, mongoCredential.password, MongoCredential.mapWith(mongoCredential.mechanismProperties, Assertions.notNull("mechanismPropertyKey", string).toLowerCase(), t));
    }

    private static <T> Map<String, Object> mapWith(Map<String, Object> map, String string, T t) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
        hashMap.put(string, t);
        return hashMap;
    }

    @Nullable
    public String getMechanism() {
        return this.mechanism == null ? null : this.mechanism.getMechanismName();
    }

    @Nullable
    public AuthenticationMechanism getAuthenticationMechanism() {
        return this.mechanism;
    }

    @Nullable
    public String getUserName() {
        return this.userName;
    }

    public String getSource() {
        return this.source;
    }

    @Nullable
    public char[] getPassword() {
        if (this.password == null) {
            return null;
        }
        return (char[])this.password.clone();
    }

    @Nullable
    public <T> T getMechanismProperty(String string, @Nullable T t) {
        Assertions.notNull("key", string);
        Object object = this.mechanismProperties.get(string.toLowerCase());
        return (T)(object == null ? t : object);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MongoCredential mongoCredential = (MongoCredential)object;
        if (this.mechanism != mongoCredential.mechanism) {
            return false;
        }
        if (!Arrays.equals(this.password, mongoCredential.password)) {
            return false;
        }
        if (!this.source.equals(mongoCredential.source)) {
            return false;
        }
        if (!Objects.equals(this.userName, mongoCredential.userName)) {
            return false;
        }
        return this.mechanismProperties.equals(mongoCredential.mechanismProperties);
    }

    public int hashCode() {
        int n = this.mechanism != null ? this.mechanism.hashCode() : 0;
        n = 31 * n + (this.userName != null ? this.userName.hashCode() : 0);
        n = 31 * n + this.source.hashCode();
        n = 31 * n + (this.password != null ? Arrays.hashCode(this.password) : 0);
        n = 31 * n + this.mechanismProperties.hashCode();
        return n;
    }

    public String toString() {
        return "MongoCredential{mechanism=" + (Object)((Object)this.mechanism) + ", userName='" + this.userName + '\'' + ", source='" + this.source + '\'' + ", password=<hidden>, mechanismProperties=<hidden>" + '}';
    }

    public static final class OidcCallbackResult {
        private final String accessToken;
        private final Duration expiresIn;
        @Nullable
        private final String refreshToken;

        public OidcCallbackResult(String string) {
            this(string, Duration.ZERO, null);
        }

        public OidcCallbackResult(String string, Duration duration) {
            this(string, duration, null);
        }

        public OidcCallbackResult(String string, Duration duration, @Nullable String string2) {
            Assertions.notNull("accessToken", string);
            Assertions.notNull("expiresIn", duration);
            if (duration.isNegative()) {
                throw new IllegalArgumentException("expiresIn must not be a negative value");
            }
            this.accessToken = string;
            this.expiresIn = duration;
            this.refreshToken = string2;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        @Nullable
        public String getRefreshToken() {
            return this.refreshToken;
        }
    }

    @Evolving
    public static interface IdpInfo {
        public String getIssuer();

        @Nullable
        public String getClientId();

        public List<String> getRequestScopes();
    }

    public static interface OidcCallback {
        public OidcCallbackResult onRequest(OidcCallbackContext var1);
    }

    @Evolving
    public static interface OidcCallbackContext {
        @Nullable
        public String getUserName();

        public Duration getTimeout();

        public int getVersion();

        @Nullable
        public IdpInfo getIdpInfo();

        @Nullable
        public String getRefreshToken();
    }
}

