/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MongoDriverInformation {
    private final List<String> driverNames;
    private final List<String> driverVersions;
    private final List<String> driverPlatforms;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MongoDriverInformation mongoDriverInformation) {
        return new Builder(mongoDriverInformation);
    }

    public List<String> getDriverNames() {
        return this.driverNames;
    }

    public List<String> getDriverVersions() {
        return this.driverVersions;
    }

    public List<String> getDriverPlatforms() {
        return this.driverPlatforms;
    }

    private MongoDriverInformation(List<String> list, List<String> list2, List<String> list3) {
        this.driverNames = list;
        this.driverVersions = list2;
        this.driverPlatforms = list3;
    }

    @NotThreadSafe
    public static final class Builder {
        private final MongoDriverInformation driverInformation;
        private String driverName;
        private String driverVersion;
        private String driverPlatform;

        public Builder driverName(String string) {
            this.driverName = Assertions.notNull("driverName", string);
            return this;
        }

        public Builder driverVersion(String string) {
            this.driverVersion = Assertions.notNull("driverVersion", string);
            return this;
        }

        public Builder driverPlatform(String string) {
            this.driverPlatform = Assertions.notNull("driverPlatform", string);
            return this;
        }

        public MongoDriverInformation build() {
            Assertions.isTrue("You must also set the driver name when setting the driver version", this.driverName != null || this.driverVersion == null);
            List<String> list = this.prependToList(this.driverInformation.getDriverNames(), this.driverName);
            List<String> list2 = this.prependToList(this.driverInformation.getDriverVersions(), this.driverVersion);
            List<String> list3 = this.prependToList(this.driverInformation.getDriverPlatforms(), this.driverPlatform);
            return new MongoDriverInformation(list, list2, list3);
        }

        private List<String> prependToList(List<String> list, String string) {
            if (string == null) {
                return list;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.addAll(list);
            return Collections.unmodifiableList(arrayList);
        }

        private Builder() {
            List list = Collections.emptyList();
            this.driverInformation = new MongoDriverInformation(list, list, list);
        }

        private Builder(MongoDriverInformation mongoDriverInformation) {
            this.driverInformation = Assertions.notNull("driverInformation", mongoDriverInformation);
        }
    }
}

