/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class MongoException
extends RuntimeException {
    public static final String TRANSIENT_TRANSACTION_ERROR_LABEL = "TransientTransactionError";
    public static final String UNKNOWN_TRANSACTION_COMMIT_RESULT_LABEL = "UnknownTransactionCommitResult";
    private static final long serialVersionUID = -4415279469780082174L;
    private final int code;
    private final Set<String> errorLabels = new HashSet<String>();

    @Nullable
    public static MongoException fromThrowable(@Nullable Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        return MongoException.fromThrowableNonNull(throwable);
    }

    public static MongoException fromThrowableNonNull(Throwable throwable) {
        if (throwable instanceof MongoException) {
            return (MongoException)throwable;
        }
        return new MongoException(throwable.getMessage(), throwable);
    }

    public MongoException(String string) {
        super(string);
        this.code = -3;
    }

    public MongoException(int n, String string) {
        super(string);
        this.code = n;
    }

    public MongoException(@Nullable String string, @Nullable Throwable throwable) {
        super(string, throwable);
        this.code = -4;
    }

    public MongoException(int n, String string, Throwable throwable) {
        super(string, throwable);
        this.code = n;
        if (throwable instanceof MongoException) {
            this.addLabels(((MongoException)throwable).getErrorLabels());
        }
    }

    public MongoException(int n, String string, BsonDocument bsonDocument) {
        super(string);
        this.code = n;
        this.addLabels(bsonDocument.getArray("errorLabels", new BsonArray()));
    }

    public int getCode() {
        return this.code;
    }

    public void addLabel(String string) {
        Assertions.notNull("errorLabel", string);
        this.errorLabels.add(string);
    }

    public void removeLabel(String string) {
        Assertions.notNull("errorLabel", string);
        this.errorLabels.remove(string);
    }

    public Set<String> getErrorLabels() {
        return Collections.unmodifiableSet(this.errorLabels);
    }

    public boolean hasErrorLabel(String string) {
        Assertions.notNull("errorLabel", string);
        return this.errorLabels.contains(string);
    }

    protected void addLabels(BsonArray bsonArray) {
        for (BsonValue bsonValue : bsonArray) {
            this.addLabel(bsonValue.asString().getValue());
        }
    }

    protected void addLabels(Collection<String> collection) {
        for (String string : collection) {
            this.addLabel(string);
        }
    }
}

