/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonIgnore;
import org.bson.codecs.pojo.annotations.BsonProperty;

@Immutable
public final class MongoNamespace {
    public static final String COMMAND_COLLECTION_NAME = "$cmd";
    private static final Set<Character> PROHIBITED_CHARACTERS_IN_DATABASE_NAME = new HashSet<Character>(Arrays.asList(Character.valueOf('\u0000'), Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf(' '), Character.valueOf('\"'), Character.valueOf('.')));
    private final String databaseName;
    private final String collectionName;
    @BsonIgnore
    private final String fullName;

    public static void checkDatabaseNameValidity(String string) {
        Assertions.notNull("databaseName", string);
        Assertions.isTrueArgument("databaseName is not empty", !string.isEmpty());
        for (int i = 0; i < string.length(); ++i) {
            if (!PROHIBITED_CHARACTERS_IN_DATABASE_NAME.contains(Character.valueOf(string.charAt(i)))) continue;
            throw new IllegalArgumentException("state should be: databaseName does not contain '" + string.charAt(i) + "'");
        }
    }

    public static void checkCollectionNameValidity(String string) {
        Assertions.notNull("collectionName", string);
        Assertions.isTrueArgument("collectionName is not empty", !string.isEmpty());
    }

    public MongoNamespace(String string) {
        Assertions.notNull("fullName", string);
        this.fullName = string;
        this.databaseName = MongoNamespace.getDatatabaseNameFromFullName(string);
        this.collectionName = MongoNamespace.getCollectionNameFullName(string);
        MongoNamespace.checkDatabaseNameValidity(this.databaseName);
        MongoNamespace.checkCollectionNameValidity(this.collectionName);
    }

    @BsonCreator
    public MongoNamespace(@BsonProperty(value="db") String string, @BsonProperty(value="coll") String string2) {
        MongoNamespace.checkDatabaseNameValidity(string);
        MongoNamespace.checkCollectionNameValidity(string2);
        this.databaseName = string;
        this.collectionName = string2;
        this.fullName = string + '.' + string2;
    }

    @BsonProperty(value="db")
    public String getDatabaseName() {
        return this.databaseName;
    }

    @BsonProperty(value="coll")
    public String getCollectionName() {
        return this.collectionName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MongoNamespace mongoNamespace = (MongoNamespace)object;
        if (!this.collectionName.equals(mongoNamespace.collectionName)) {
            return false;
        }
        return this.databaseName.equals(mongoNamespace.databaseName);
    }

    public String toString() {
        return this.fullName;
    }

    public int hashCode() {
        int n = this.databaseName.hashCode();
        n = 31 * n + this.collectionName.hashCode();
        return n;
    }

    private static String getCollectionNameFullName(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static String getDatatabaseNameFromFullName(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }
}

