/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ReadConcernLevel;
import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonString;

public final class ReadConcern {
    private final ReadConcernLevel level;
    public static final ReadConcern DEFAULT = new ReadConcern();
    public static final ReadConcern LOCAL = new ReadConcern(ReadConcernLevel.LOCAL);
    public static final ReadConcern MAJORITY = new ReadConcern(ReadConcernLevel.MAJORITY);
    public static final ReadConcern LINEARIZABLE = new ReadConcern(ReadConcernLevel.LINEARIZABLE);
    public static final ReadConcern SNAPSHOT = new ReadConcern(ReadConcernLevel.SNAPSHOT);
    public static final ReadConcern AVAILABLE = new ReadConcern(ReadConcernLevel.AVAILABLE);

    public ReadConcern(ReadConcernLevel readConcernLevel) {
        this.level = Assertions.notNull("level", readConcernLevel);
    }

    @Nullable
    public ReadConcernLevel getLevel() {
        return this.level;
    }

    public boolean isServerDefault() {
        return this.level == null;
    }

    public BsonDocument asDocument() {
        BsonDocument bsonDocument = new BsonDocument();
        if (this.level != null) {
            bsonDocument.put("level", new BsonString(this.level.getValue()));
        }
        return bsonDocument;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ReadConcern readConcern = (ReadConcern)object;
        return this.level == readConcern.level;
    }

    public int hashCode() {
        return this.level != null ? this.level.hashCode() : 0;
    }

    public String toString() {
        return "ReadConcern{level=" + (Object)((Object)this.level) + '}';
    }

    private ReadConcern() {
        this.level = null;
    }
}

