/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ReadPreferenceHedgeOptions;
import com.mongodb.TagSet;
import com.mongodb.TaggableReadPreference;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.connection.ClusterDescriptionHelper;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonString;

@Immutable
public abstract class ReadPreference {
    private static final ReadPreference PRIMARY = new PrimaryReadPreference();
    private static final ReadPreference SECONDARY = new TaggableReadPreference.SecondaryReadPreference();
    private static final ReadPreference SECONDARY_PREFERRED = new TaggableReadPreference.SecondaryPreferredReadPreference();
    private static final ReadPreference PRIMARY_PREFERRED = new TaggableReadPreference.PrimaryPreferredReadPreference();
    private static final ReadPreference NEAREST = new TaggableReadPreference.NearestReadPreference();

    ReadPreference() {
    }

    public abstract ReadPreference withTagSet(TagSet var1);

    public abstract ReadPreference withTagSetList(List<TagSet> var1);

    public abstract ReadPreference withMaxStalenessMS(Long var1, TimeUnit var2);

    public abstract ReadPreference withHedgeOptions(ReadPreferenceHedgeOptions var1);

    public abstract boolean isSecondaryOk();

    public abstract String getName();

    public abstract BsonDocument toDocument();

    public final List<ServerDescription> choose(ClusterDescription clusterDescription) {
        switch (clusterDescription.getType()) {
            case REPLICA_SET: {
                return this.chooseForReplicaSet(clusterDescription);
            }
            case SHARDED: 
            case STANDALONE: {
                return this.chooseForNonReplicaSet(clusterDescription);
            }
            case LOAD_BALANCED: {
                return clusterDescription.getServerDescriptions();
            }
            case UNKNOWN: {
                return Collections.emptyList();
            }
        }
        throw new UnsupportedOperationException("Unsupported cluster type: " + (Object)((Object)clusterDescription.getType()));
    }

    protected abstract List<ServerDescription> chooseForNonReplicaSet(ClusterDescription var1);

    protected abstract List<ServerDescription> chooseForReplicaSet(ClusterDescription var1);

    public static ReadPreference primary() {
        return PRIMARY;
    }

    public static ReadPreference primaryPreferred() {
        return PRIMARY_PREFERRED;
    }

    public static ReadPreference secondary() {
        return SECONDARY;
    }

    public static ReadPreference secondaryPreferred() {
        return SECONDARY_PREFERRED;
    }

    public static ReadPreference nearest() {
        return NEAREST;
    }

    public static ReadPreference primaryPreferred(long l, TimeUnit timeUnit) {
        return new TaggableReadPreference.PrimaryPreferredReadPreference(Collections.emptyList(), l, timeUnit);
    }

    public static ReadPreference secondary(long l, TimeUnit timeUnit) {
        return new TaggableReadPreference.SecondaryReadPreference(Collections.emptyList(), l, timeUnit);
    }

    public static ReadPreference secondaryPreferred(long l, TimeUnit timeUnit) {
        return new TaggableReadPreference.SecondaryPreferredReadPreference(Collections.emptyList(), l, timeUnit);
    }

    public static ReadPreference nearest(long l, TimeUnit timeUnit) {
        return new TaggableReadPreference.NearestReadPreference(Collections.emptyList(), l, timeUnit);
    }

    public static TaggableReadPreference primaryPreferred(TagSet tagSet) {
        return new TaggableReadPreference.PrimaryPreferredReadPreference(Collections.singletonList(tagSet), null, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference secondary(TagSet tagSet) {
        return new TaggableReadPreference.SecondaryReadPreference(Collections.singletonList(tagSet), null, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference secondaryPreferred(TagSet tagSet) {
        return new TaggableReadPreference.SecondaryPreferredReadPreference(Collections.singletonList(tagSet), null, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference nearest(TagSet tagSet) {
        return new TaggableReadPreference.NearestReadPreference(Collections.singletonList(tagSet), null, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference primaryPreferred(TagSet tagSet, long l, TimeUnit timeUnit) {
        return new TaggableReadPreference.PrimaryPreferredReadPreference(Collections.singletonList(tagSet), l, timeUnit);
    }

    public static TaggableReadPreference secondary(TagSet tagSet, long l, TimeUnit timeUnit) {
        return new TaggableReadPreference.SecondaryReadPreference(Collections.singletonList(tagSet), l, timeUnit);
    }

    public static TaggableReadPreference secondaryPreferred(TagSet tagSet, long l, TimeUnit timeUnit) {
        return new TaggableReadPreference.SecondaryPreferredReadPreference(Collections.singletonList(tagSet), l, timeUnit);
    }

    public static TaggableReadPreference nearest(TagSet tagSet, long l, TimeUnit timeUnit) {
        return new TaggableReadPreference.NearestReadPreference(Collections.singletonList(tagSet), l, timeUnit);
    }

    public static TaggableReadPreference primaryPreferred(List<TagSet> list) {
        return new TaggableReadPreference.PrimaryPreferredReadPreference(list, null, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference secondary(List<TagSet> list) {
        return new TaggableReadPreference.SecondaryReadPreference(list, null, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference secondaryPreferred(List<TagSet> list) {
        return new TaggableReadPreference.SecondaryPreferredReadPreference(list, null, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference nearest(List<TagSet> list) {
        return new TaggableReadPreference.NearestReadPreference(list, null, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference primaryPreferred(List<TagSet> list, long l, TimeUnit timeUnit) {
        return new TaggableReadPreference.PrimaryPreferredReadPreference(list, l, timeUnit);
    }

    public static TaggableReadPreference secondary(List<TagSet> list, long l, TimeUnit timeUnit) {
        return new TaggableReadPreference.SecondaryReadPreference(list, l, timeUnit);
    }

    public static TaggableReadPreference secondaryPreferred(List<TagSet> list, long l, TimeUnit timeUnit) {
        return new TaggableReadPreference.SecondaryPreferredReadPreference(list, l, timeUnit);
    }

    public static TaggableReadPreference nearest(List<TagSet> list, long l, TimeUnit timeUnit) {
        return new TaggableReadPreference.NearestReadPreference(list, l, timeUnit);
    }

    public static ReadPreference valueOf(String string) {
        Assertions.notNull("name", string);
        String string2 = string.toLowerCase();
        if (string2.equals(PRIMARY.getName().toLowerCase())) {
            return PRIMARY;
        }
        if (string2.equals(SECONDARY.getName().toLowerCase())) {
            return SECONDARY;
        }
        if (string2.equals(SECONDARY_PREFERRED.getName().toLowerCase())) {
            return SECONDARY_PREFERRED;
        }
        if (string2.equals(PRIMARY_PREFERRED.getName().toLowerCase())) {
            return PRIMARY_PREFERRED;
        }
        if (string2.equals(NEAREST.getName().toLowerCase())) {
            return NEAREST;
        }
        throw new IllegalArgumentException("No match for read preference of " + string);
    }

    public static TaggableReadPreference valueOf(String string, List<TagSet> list) {
        return ReadPreference.valueOf(string, list, null, TimeUnit.MILLISECONDS);
    }

    public static TaggableReadPreference valueOf(String string, List<TagSet> list, long l, TimeUnit timeUnit) {
        return ReadPreference.valueOf(string, list, (Long)l, timeUnit);
    }

    private static TaggableReadPreference valueOf(String string, List<TagSet> list, @Nullable Long l, TimeUnit timeUnit) {
        Assertions.notNull("name", string);
        Assertions.notNull("tagSetList", list);
        Assertions.notNull("timeUnit", timeUnit);
        String string2 = string.toLowerCase();
        if (string2.equals(PRIMARY.getName().toLowerCase())) {
            throw new IllegalArgumentException("Primary read preference can not also specify tag sets, max staleness or hedge");
        }
        if (string2.equals(SECONDARY.getName().toLowerCase())) {
            return new TaggableReadPreference.SecondaryReadPreference(list, l, timeUnit);
        }
        if (string2.equals(SECONDARY_PREFERRED.getName().toLowerCase())) {
            return new TaggableReadPreference.SecondaryPreferredReadPreference(list, l, timeUnit);
        }
        if (string2.equals(PRIMARY_PREFERRED.getName().toLowerCase())) {
            return new TaggableReadPreference.PrimaryPreferredReadPreference(list, l, timeUnit);
        }
        if (string2.equals(NEAREST.getName().toLowerCase())) {
            return new TaggableReadPreference.NearestReadPreference(list, l, timeUnit);
        }
        throw new IllegalArgumentException("No match for read preference of " + string);
    }

    private static final class PrimaryReadPreference
    extends ReadPreference {
        private PrimaryReadPreference() {
        }

        @Override
        public ReadPreference withTagSet(TagSet tagSet) {
            throw new UnsupportedOperationException("Primary read preference can not also specify tag sets");
        }

        @Override
        public TaggableReadPreference withTagSetList(List<TagSet> list) {
            throw new UnsupportedOperationException("Primary read preference can not also specify tag sets");
        }

        @Override
        public TaggableReadPreference withMaxStalenessMS(Long l, TimeUnit timeUnit) {
            throw new UnsupportedOperationException("Primary read preference can not also specify max staleness");
        }

        @Override
        public TaggableReadPreference withHedgeOptions(ReadPreferenceHedgeOptions readPreferenceHedgeOptions) {
            throw new UnsupportedOperationException("Primary read preference can not also specify hedge");
        }

        @Override
        public boolean isSecondaryOk() {
            return false;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object object) {
            return object != null && this.getClass() == object.getClass();
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        @Override
        public BsonDocument toDocument() {
            return new BsonDocument("mode", new BsonString(this.getName()));
        }

        @Override
        protected List<ServerDescription> chooseForReplicaSet(ClusterDescription clusterDescription) {
            return ClusterDescriptionHelper.getPrimaries(clusterDescription);
        }

        @Override
        protected List<ServerDescription> chooseForNonReplicaSet(ClusterDescription clusterDescription) {
            return ClusterDescriptionHelper.getAny(clusterDescription);
        }

        @Override
        public String getName() {
            return "primary";
        }
    }
}

