/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoException;
import com.mongodb.annotations.Immutable;
import com.mongodb.lang.Nullable;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;

@Immutable
public class ServerAddress
implements Serializable {
    private static final long serialVersionUID = 4027873363095395504L;
    private final String host;
    private final int port;

    public ServerAddress() {
        this(ServerAddress.defaultHost(), ServerAddress.defaultPort());
    }

    public ServerAddress(@Nullable String string) {
        this(string, ServerAddress.defaultPort());
    }

    public ServerAddress(InetAddress inetAddress) {
        this(inetAddress.getHostName(), ServerAddress.defaultPort());
    }

    public ServerAddress(InetAddress inetAddress, int n) {
        this(inetAddress.getHostName(), n);
    }

    public ServerAddress(InetSocketAddress inetSocketAddress) {
        this(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
    }

    public ServerAddress(@Nullable String string, int n) {
        String string2 = string;
        if (string2 == null) {
            string2 = ServerAddress.defaultHost();
        }
        if ((string2 = string2.trim()).length() == 0) {
            string2 = ServerAddress.defaultHost();
        }
        int n2 = n;
        if (string2.startsWith("[")) {
            int n3 = string.indexOf("]");
            if (n3 == -1) {
                throw new IllegalArgumentException("an IPV6 address must be enclosed with '[' and ']' according to RFC 2732.");
            }
            int n4 = string.indexOf("]:");
            if (n4 != -1) {
                if (n != ServerAddress.defaultPort()) {
                    throw new IllegalArgumentException("can't specify port in construct and via host");
                }
                n2 = Integer.parseInt(string.substring(n4 + 2));
            }
            string2 = string.substring(1, n3);
        } else {
            int n5;
            int n6 = string2.indexOf(":");
            if (n6 == (n5 = string2.lastIndexOf(":")) && n6 > 0) {
                if (n != ServerAddress.defaultPort()) {
                    throw new IllegalArgumentException("can't specify port in construct and via host");
                }
                try {
                    n2 = Integer.parseInt(string2.substring(n6 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MongoException("host and port should be specified in host:port format");
                }
                string2 = string2.substring(0, n6).trim();
            }
        }
        this.host = string2.toLowerCase();
        this.port = n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ServerAddress serverAddress = (ServerAddress)object;
        if (this.port != serverAddress.port) {
            return false;
        }
        return this.host.equals(serverAddress.host);
    }

    public int hashCode() {
        int n = this.host.hashCode();
        n = 31 * n + this.port;
        return n;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public static String defaultHost() {
        return "127.0.0.1";
    }

    public static int defaultPort() {
        return 27017;
    }
}

