/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ServerApiVersion;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.util.Objects;
import java.util.Optional;

public final class ServerApi {
    private final ServerApiVersion version;
    private final Boolean deprecationErrors;
    private final Boolean strict;

    private ServerApi(ServerApiVersion serverApiVersion, @Nullable Boolean bl, @Nullable Boolean bl2) {
        this.version = Assertions.notNull("version", serverApiVersion);
        this.deprecationErrors = bl2;
        this.strict = bl;
    }

    public ServerApiVersion getVersion() {
        return this.version;
    }

    public Optional<Boolean> getStrict() {
        return Optional.ofNullable(this.strict);
    }

    public Optional<Boolean> getDeprecationErrors() {
        return Optional.ofNullable(this.deprecationErrors);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ServerApi{version=" + (Object)((Object)this.version) + ", deprecationErrors=" + this.deprecationErrors + ", strict=" + this.strict + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ServerApi serverApi = (ServerApi)object;
        if (this.version != serverApi.version) {
            return false;
        }
        if (!Objects.equals(this.deprecationErrors, serverApi.deprecationErrors)) {
            return false;
        }
        return Objects.equals(this.strict, serverApi.strict);
    }

    public int hashCode() {
        int n = this.version.hashCode();
        n = 31 * n + (this.deprecationErrors != null ? this.deprecationErrors.hashCode() : 0);
        n = 31 * n + (this.strict != null ? this.strict.hashCode() : 0);
        return n;
    }

    @NotThreadSafe
    public static final class Builder {
        private ServerApiVersion version;
        private Boolean deprecationErrors;
        private Boolean strict;

        private Builder() {
        }

        public Builder version(ServerApiVersion serverApiVersion) {
            this.version = serverApiVersion;
            return this;
        }

        public Builder deprecationErrors(boolean bl) {
            this.deprecationErrors = bl;
            return this;
        }

        public Builder strict(boolean bl) {
            this.strict = bl;
            return this;
        }

        public ServerApi build() {
            return new ServerApi(this.version, this.strict, this.deprecationErrors);
        }
    }
}

