/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ServerAddress;
import com.mongodb.annotations.Immutable;
import java.io.Serializable;

@Immutable
public final class ServerCursor
implements Serializable {
    private static final long serialVersionUID = -7013636754565190109L;
    private final long id;
    private final ServerAddress address;

    public ServerCursor(long l, ServerAddress serverAddress) {
        if (l == 0L) {
            throw new IllegalArgumentException();
        }
        this.id = l;
        this.address = serverAddress;
    }

    public long getId() {
        return this.id;
    }

    public ServerAddress getAddress() {
        return this.address;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ServerCursor serverCursor = (ServerCursor)object;
        if (this.id != serverCursor.id) {
            return false;
        }
        return this.address.equals(serverCursor.address);
    }

    public int hashCode() {
        int n = (int)(this.id ^ this.id >>> 32);
        n = 31 * n + this.address.hashCode();
        return n;
    }

    public String toString() {
        return "ServerCursor{getId=" + this.id + ", address=" + this.address + '}';
    }
}

