/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Tag;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

@Immutable
public final class TagSet
implements Iterable<Tag> {
    private final List<Tag> wrapped;

    public TagSet() {
        this.wrapped = Collections.emptyList();
    }

    public TagSet(Tag tag) {
        Assertions.notNull("tag", tag);
        this.wrapped = Collections.singletonList(tag);
    }

    public TagSet(List<Tag> list) {
        Assertions.notNull("tagList", list);
        HashSet<String> hashSet = new HashSet<String>();
        for (Tag tag3 : list) {
            if (tag3 == null) {
                throw new IllegalArgumentException("Null tags are not allowed");
            }
            if (hashSet.add(tag3.getName())) continue;
            throw new IllegalArgumentException("Duplicate tag names not allowed in a tag set: " + tag3.getName());
        }
        ArrayList<Tag> arrayList = new ArrayList<Tag>(list);
        Collections.sort(arrayList, (tag, tag2) -> tag.getName().compareTo(tag2.getName()));
        this.wrapped = Collections.unmodifiableList(arrayList);
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.wrapped.iterator();
    }

    public boolean containsAll(TagSet tagSet) {
        return this.wrapped.containsAll(tagSet.wrapped);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TagSet tagSet = (TagSet)object;
        return this.wrapped.equals(tagSet.wrapped);
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public String toString() {
        return "TagSet{" + this.wrapped + '}';
    }
}

