/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoClientException;
import com.mongodb.MongoConfigurationException;
import com.mongodb.ReadPreference;
import com.mongodb.ReadPreferenceHedgeOptions;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.connection.ClusterDescriptionHelper;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonString;

@Immutable
public abstract class TaggableReadPreference
extends ReadPreference {
    private static final int SMALLEST_MAX_STALENESS_MS = 90000;
    private static final int IDLE_WRITE_PERIOD_MS = 10000;
    private final List<TagSet> tagSetList = new ArrayList<TagSet>();
    private final Long maxStalenessMS;
    private final ReadPreferenceHedgeOptions hedgeOptions;

    TaggableReadPreference() {
        this.maxStalenessMS = null;
        this.hedgeOptions = null;
    }

    TaggableReadPreference(List<TagSet> list, @Nullable Long l, TimeUnit timeUnit, @Nullable ReadPreferenceHedgeOptions readPreferenceHedgeOptions) {
        Assertions.notNull("tagSetList", list);
        Assertions.isTrueArgument("maxStaleness is null or >= 0", l == null || l >= 0L);
        this.maxStalenessMS = l == null ? null : Long.valueOf(TimeUnit.MILLISECONDS.convert(l, timeUnit));
        this.tagSetList.addAll(list);
        this.hedgeOptions = readPreferenceHedgeOptions;
    }

    @Override
    public abstract TaggableReadPreference withTagSet(TagSet var1);

    @Override
    public abstract TaggableReadPreference withTagSetList(List<TagSet> var1);

    @Override
    public abstract TaggableReadPreference withMaxStalenessMS(Long var1, TimeUnit var2);

    @Override
    public abstract TaggableReadPreference withHedgeOptions(ReadPreferenceHedgeOptions var1);

    @Override
    public boolean isSecondaryOk() {
        return true;
    }

    @Override
    public BsonDocument toDocument() {
        BsonDocument bsonDocument = new BsonDocument("mode", new BsonString(this.getName()));
        if (!this.tagSetList.isEmpty()) {
            bsonDocument.put("tags", this.tagsListToBsonArray());
        }
        if (this.maxStalenessMS != null) {
            bsonDocument.put("maxStalenessSeconds", new BsonInt64(TimeUnit.MILLISECONDS.toSeconds(this.maxStalenessMS)));
        }
        if (this.hedgeOptions != null) {
            bsonDocument.put("hedge", this.hedgeOptions.toBsonDocument());
        }
        return bsonDocument;
    }

    public List<TagSet> getTagSetList() {
        return Collections.unmodifiableList(this.tagSetList);
    }

    @Nullable
    public Long getMaxStaleness(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        if (this.maxStalenessMS == null) {
            return null;
        }
        return timeUnit.convert(this.maxStalenessMS, TimeUnit.MILLISECONDS);
    }

    @Nullable
    public ReadPreferenceHedgeOptions getHedgeOptions() {
        return this.hedgeOptions;
    }

    public String toString() {
        return "ReadPreference{name=" + this.getName() + (this.tagSetList.isEmpty() ? "" : ", tagSetList=" + this.tagSetList) + (this.maxStalenessMS == null ? "" : ", maxStalenessMS=" + this.maxStalenessMS) + ", hedgeOptions=" + this.hedgeOptions + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TaggableReadPreference taggableReadPreference = (TaggableReadPreference)object;
        if (!Objects.equals(this.maxStalenessMS, taggableReadPreference.maxStalenessMS)) {
            return false;
        }
        if (!this.tagSetList.equals(taggableReadPreference.tagSetList)) {
            return false;
        }
        return Objects.equals(this.hedgeOptions, taggableReadPreference.hedgeOptions);
    }

    public int hashCode() {
        int n = this.tagSetList.hashCode();
        n = 31 * n + this.getName().hashCode();
        n = 31 * n + (this.maxStalenessMS != null ? this.maxStalenessMS.hashCode() : 0);
        n = 31 * n + (this.hedgeOptions != null ? this.hedgeOptions.hashCode() : 0);
        return n;
    }

    @Override
    protected List<ServerDescription> chooseForNonReplicaSet(ClusterDescription clusterDescription) {
        return this.selectFreshServers(clusterDescription, ClusterDescriptionHelper.getAny(clusterDescription));
    }

    static ClusterDescription copyClusterDescription(ClusterDescription clusterDescription, List<ServerDescription> list) {
        return new ClusterDescription(clusterDescription.getConnectionMode(), clusterDescription.getType(), list, clusterDescription.getClusterSettings(), clusterDescription.getServerSettings());
    }

    List<ServerDescription> selectFreshServers(ClusterDescription clusterDescription, List<ServerDescription> list) {
        ArrayList<ServerDescription> arrayList;
        block10: {
            long l;
            Long l2;
            block9: {
                l2 = this.getMaxStaleness(TimeUnit.MILLISECONDS);
                if (l2 == null) {
                    return list;
                }
                if (clusterDescription.getServerSettings() == null) {
                    throw new MongoConfigurationException("heartbeat frequency must be provided in cluster description");
                }
                if (!this.serversAreAllThreeDotFour(clusterDescription)) {
                    throw new MongoConfigurationException("Servers must all be at least version 3.4 when max staleness is configured");
                }
                if (clusterDescription.getType() != ClusterType.REPLICA_SET) {
                    return list;
                }
                l = clusterDescription.getServerSettings().getHeartbeatFrequency(TimeUnit.MILLISECONDS);
                if (l2 < Math.max(90000L, l + 10000L)) {
                    if (90000L > l + 10000L) {
                        throw new MongoConfigurationException(String.format("Max staleness (%d sec) must be at least 90 seconds", this.getMaxStaleness(TimeUnit.SECONDS)));
                    }
                    throw new MongoConfigurationException(String.format("Max staleness (%d ms) must be at least the heartbeat period (%d ms) plus the idle write period (%d ms)", l2, l, 10000));
                }
                arrayList = new ArrayList<ServerDescription>(list.size());
                ServerDescription serverDescription = this.findPrimary(clusterDescription);
                if (serverDescription == null) break block9;
                for (ServerDescription serverDescription2 : list) {
                    if (serverDescription2.isPrimary()) {
                        arrayList.add(serverDescription2);
                        continue;
                    }
                    if (this.getStalenessOfSecondaryRelativeToPrimary(serverDescription, serverDescription2, l) > l2) continue;
                    arrayList.add(serverDescription2);
                }
                break block10;
            }
            ServerDescription serverDescription = this.findMostUpToDateSecondary(clusterDescription);
            if (serverDescription == null) break block10;
            for (ServerDescription serverDescription3 : list) {
                if (this.getLastWriteDateNonNull(serverDescription).getTime() - this.getLastWriteDateNonNull(serverDescription3).getTime() + l > l2) continue;
                arrayList.add(serverDescription3);
            }
        }
        return arrayList;
    }

    private long getStalenessOfSecondaryRelativeToPrimary(ServerDescription serverDescription, ServerDescription serverDescription2, long l) {
        return this.getLastWriteDateNonNull(serverDescription).getTime() + (serverDescription2.getLastUpdateTime(TimeUnit.MILLISECONDS) - serverDescription.getLastUpdateTime(TimeUnit.MILLISECONDS)) - this.getLastWriteDateNonNull(serverDescription2).getTime() + l;
    }

    @Nullable
    private ServerDescription findPrimary(ClusterDescription clusterDescription) {
        for (ServerDescription serverDescription : clusterDescription.getServerDescriptions()) {
            if (!serverDescription.isPrimary()) continue;
            return serverDescription;
        }
        return null;
    }

    private ServerDescription findMostUpToDateSecondary(ClusterDescription clusterDescription) {
        ServerDescription serverDescription = null;
        for (ServerDescription serverDescription2 : clusterDescription.getServerDescriptions()) {
            if (!serverDescription2.isSecondary() || serverDescription != null && this.getLastWriteDateNonNull(serverDescription2).getTime() <= this.getLastWriteDateNonNull(serverDescription).getTime()) continue;
            serverDescription = serverDescription2;
        }
        return serverDescription;
    }

    private Date getLastWriteDateNonNull(ServerDescription serverDescription) {
        Date date = serverDescription.getLastWriteDate();
        if (date == null) {
            throw new MongoClientException("lastWriteDate should not be null in " + serverDescription);
        }
        return date;
    }

    private boolean serversAreAllThreeDotFour(ClusterDescription clusterDescription) {
        for (ServerDescription serverDescription : clusterDescription.getServerDescriptions()) {
            if (!serverDescription.isOk() || serverDescription.getMaxWireVersion() >= 5) continue;
            return false;
        }
        return true;
    }

    private BsonArray tagsListToBsonArray() {
        BsonArray bsonArray = new BsonArray(this.tagSetList.size());
        for (TagSet tagSet : this.tagSetList) {
            bsonArray.add(this.toDocument(tagSet));
        }
        return bsonArray;
    }

    private BsonDocument toDocument(TagSet tagSet) {
        BsonDocument bsonDocument = new BsonDocument();
        for (Tag tag : tagSet) {
            bsonDocument.put(tag.getName(), new BsonString(tag.getValue()));
        }
        return bsonDocument;
    }

    static class PrimaryPreferredReadPreference
    extends SecondaryReadPreference {
        PrimaryPreferredReadPreference() {
        }

        PrimaryPreferredReadPreference(List<TagSet> list, @Nullable Long l, TimeUnit timeUnit) {
            this(list, l, timeUnit, null);
        }

        PrimaryPreferredReadPreference(List<TagSet> list, @Nullable Long l, TimeUnit timeUnit, @Nullable ReadPreferenceHedgeOptions readPreferenceHedgeOptions) {
            super(list, l, timeUnit, readPreferenceHedgeOptions);
        }

        @Override
        public TaggableReadPreference withTagSet(TagSet tagSet) {
            return this.withTagSetList((List)Collections.singletonList(tagSet));
        }

        @Override
        public TaggableReadPreference withTagSetList(List<TagSet> list) {
            Assertions.notNull("tagSetList", list);
            return new PrimaryPreferredReadPreference(list, this.getMaxStaleness(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, this.getHedgeOptions());
        }

        @Override
        public TaggableReadPreference withMaxStalenessMS(@Nullable Long l, TimeUnit timeUnit) {
            Assertions.isTrueArgument("maxStaleness is null or >= 0", l == null || l >= 0L);
            return new PrimaryPreferredReadPreference(this.getTagSetList(), l, timeUnit, this.getHedgeOptions());
        }

        @Override
        public TaggableReadPreference withHedgeOptions(ReadPreferenceHedgeOptions readPreferenceHedgeOptions) {
            return new PrimaryPreferredReadPreference(this.getTagSetList(), this.getMaxStaleness(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, readPreferenceHedgeOptions);
        }

        @Override
        public String getName() {
            return "primaryPreferred";
        }

        @Override
        protected List<ServerDescription> chooseForReplicaSet(ClusterDescription clusterDescription) {
            List<ServerDescription> list = this.selectFreshServers(clusterDescription, ClusterDescriptionHelper.getPrimaries(clusterDescription));
            if (list.isEmpty()) {
                list = super.chooseForReplicaSet(clusterDescription);
            }
            return list;
        }
    }

    static class NearestReadPreference
    extends TaggableReadPreference {
        NearestReadPreference() {
        }

        NearestReadPreference(List<TagSet> list, @Nullable Long l, TimeUnit timeUnit) {
            this(list, l, timeUnit, null);
        }

        NearestReadPreference(List<TagSet> list, @Nullable Long l, TimeUnit timeUnit, @Nullable ReadPreferenceHedgeOptions readPreferenceHedgeOptions) {
            super(list, l, timeUnit, readPreferenceHedgeOptions);
        }

        @Override
        public TaggableReadPreference withTagSet(TagSet tagSet) {
            return this.withTagSetList((List)Collections.singletonList(tagSet));
        }

        @Override
        public TaggableReadPreference withTagSetList(List<TagSet> list) {
            Assertions.notNull("tagSetList", list);
            return new NearestReadPreference(list, this.getMaxStaleness(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, this.getHedgeOptions());
        }

        @Override
        public TaggableReadPreference withMaxStalenessMS(@Nullable Long l, TimeUnit timeUnit) {
            Assertions.isTrueArgument("maxStaleness is null or >= 0", l == null || l >= 0L);
            return new NearestReadPreference(this.getTagSetList(), l, timeUnit, this.getHedgeOptions());
        }

        @Override
        public TaggableReadPreference withHedgeOptions(ReadPreferenceHedgeOptions readPreferenceHedgeOptions) {
            return new NearestReadPreference(this.getTagSetList(), this.getMaxStaleness(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, readPreferenceHedgeOptions);
        }

        @Override
        public String getName() {
            return "nearest";
        }

        @Override
        public List<ServerDescription> chooseForReplicaSet(ClusterDescription clusterDescription) {
            List<ServerDescription> list = this.selectFreshServers(clusterDescription, ClusterDescriptionHelper.getAnyPrimaryOrSecondary(clusterDescription));
            if (!this.getTagSetList().isEmpty()) {
                ClusterDescription clusterDescription2 = NearestReadPreference.copyClusterDescription(clusterDescription, list);
                list = Collections.emptyList();
                for (TagSet tagSet : this.getTagSetList()) {
                    List<ServerDescription> list2 = ClusterDescriptionHelper.getAnyPrimaryOrSecondary(clusterDescription2, tagSet);
                    if (list2.isEmpty()) continue;
                    list = list2;
                    break;
                }
            }
            return list;
        }
    }

    static class SecondaryPreferredReadPreference
    extends SecondaryReadPreference {
        SecondaryPreferredReadPreference() {
        }

        SecondaryPreferredReadPreference(List<TagSet> list, @Nullable Long l, TimeUnit timeUnit) {
            this(list, l, timeUnit, null);
        }

        SecondaryPreferredReadPreference(List<TagSet> list, @Nullable Long l, TimeUnit timeUnit, @Nullable ReadPreferenceHedgeOptions readPreferenceHedgeOptions) {
            super(list, l, timeUnit, readPreferenceHedgeOptions);
        }

        @Override
        public TaggableReadPreference withTagSet(TagSet tagSet) {
            return this.withTagSetList((List)Collections.singletonList(tagSet));
        }

        @Override
        public TaggableReadPreference withTagSetList(List<TagSet> list) {
            Assertions.notNull("tagSetList", list);
            return new SecondaryPreferredReadPreference(list, this.getMaxStaleness(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, this.getHedgeOptions());
        }

        @Override
        public TaggableReadPreference withMaxStalenessMS(@Nullable Long l, TimeUnit timeUnit) {
            Assertions.isTrueArgument("maxStaleness is null or >= 0", l == null || l >= 0L);
            return new SecondaryPreferredReadPreference(this.getTagSetList(), l, timeUnit, this.getHedgeOptions());
        }

        @Override
        public TaggableReadPreference withHedgeOptions(ReadPreferenceHedgeOptions readPreferenceHedgeOptions) {
            return new SecondaryPreferredReadPreference(this.getTagSetList(), this.getMaxStaleness(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, readPreferenceHedgeOptions);
        }

        @Override
        public String getName() {
            return "secondaryPreferred";
        }

        @Override
        protected List<ServerDescription> chooseForReplicaSet(ClusterDescription clusterDescription) {
            List<ServerDescription> list = super.chooseForReplicaSet(clusterDescription);
            if (list.isEmpty()) {
                list = ClusterDescriptionHelper.getPrimaries(clusterDescription);
            }
            return list;
        }
    }

    static class SecondaryReadPreference
    extends TaggableReadPreference {
        SecondaryReadPreference() {
        }

        SecondaryReadPreference(List<TagSet> list, @Nullable Long l, TimeUnit timeUnit) {
            this(list, l, timeUnit, null);
        }

        SecondaryReadPreference(List<TagSet> list, @Nullable Long l, TimeUnit timeUnit, @Nullable ReadPreferenceHedgeOptions readPreferenceHedgeOptions) {
            super(list, l, timeUnit, readPreferenceHedgeOptions);
        }

        @Override
        public TaggableReadPreference withTagSet(TagSet tagSet) {
            return this.withTagSetList((List)Collections.singletonList(tagSet));
        }

        @Override
        public TaggableReadPreference withTagSetList(List<TagSet> list) {
            Assertions.notNull("tagSetList", list);
            return new SecondaryReadPreference(list, this.getMaxStaleness(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, this.getHedgeOptions());
        }

        @Override
        public TaggableReadPreference withMaxStalenessMS(@Nullable Long l, TimeUnit timeUnit) {
            Assertions.isTrueArgument("maxStaleness is null or >= 0", l == null || l >= 0L);
            return new SecondaryReadPreference(this.getTagSetList(), l, timeUnit, this.getHedgeOptions());
        }

        @Override
        public TaggableReadPreference withHedgeOptions(ReadPreferenceHedgeOptions readPreferenceHedgeOptions) {
            return new SecondaryReadPreference(this.getTagSetList(), this.getMaxStaleness(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, readPreferenceHedgeOptions);
        }

        @Override
        public String getName() {
            return "secondary";
        }

        @Override
        protected List<ServerDescription> chooseForReplicaSet(ClusterDescription clusterDescription) {
            List<ServerDescription> list = this.selectFreshServers(clusterDescription, ClusterDescriptionHelper.getSecondaries(clusterDescription));
            if (!this.getTagSetList().isEmpty()) {
                ClusterDescription clusterDescription2 = SecondaryReadPreference.copyClusterDescription(clusterDescription, list);
                list = Collections.emptyList();
                for (TagSet tagSet : this.getTagSetList()) {
                    List<ServerDescription> list2 = ClusterDescriptionHelper.getSecondaries(clusterDescription2, tagSet);
                    if (list2.isEmpty()) continue;
                    list = list2;
                    break;
                }
            }
            return list;
        }
    }
}

