/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.Alpha;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.Reason;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.lang.Nullable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Immutable
public final class TransactionOptions {
    private final ReadConcern readConcern;
    private final WriteConcern writeConcern;
    private final ReadPreference readPreference;
    private final Long maxCommitTimeMS;
    private final Long timeoutMS;

    @Nullable
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Nullable
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Nullable
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Nullable
    public Long getMaxCommitTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        if (this.maxCommitTimeMS == null) {
            return null;
        }
        return timeUnit.convert(this.maxCommitTimeMS, TimeUnit.MILLISECONDS);
    }

    @Nullable
    @Alpha(value={Reason.CLIENT})
    public Long getTimeout(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        if (this.timeoutMS == null) {
            return null;
        }
        return timeUnit.convert(this.timeoutMS, TimeUnit.MILLISECONDS);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TransactionOptions merge(TransactionOptions transactionOptions, TransactionOptions transactionOptions2) {
        Assertions.notNull("options", transactionOptions);
        Assertions.notNull("defaultOptions", transactionOptions2);
        return TransactionOptions.builder().writeConcern(transactionOptions.getWriteConcern() == null ? transactionOptions2.getWriteConcern() : transactionOptions.getWriteConcern()).readConcern(transactionOptions.getReadConcern() == null ? transactionOptions2.getReadConcern() : transactionOptions.getReadConcern()).readPreference(transactionOptions.getReadPreference() == null ? transactionOptions2.getReadPreference() : transactionOptions.getReadPreference()).maxCommitTime(transactionOptions.getMaxCommitTime(TimeUnit.MILLISECONDS) == null ? transactionOptions2.getMaxCommitTime(TimeUnit.MILLISECONDS) : transactionOptions.getMaxCommitTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).timeout(transactionOptions.getTimeout(TimeUnit.MILLISECONDS) == null ? transactionOptions2.getTimeout(TimeUnit.MILLISECONDS) : transactionOptions.getTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).build();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TransactionOptions transactionOptions = (TransactionOptions)object;
        if (!Objects.equals(this.timeoutMS, transactionOptions.timeoutMS)) {
            return false;
        }
        if (!Objects.equals(this.maxCommitTimeMS, transactionOptions.maxCommitTimeMS)) {
            return false;
        }
        if (!Objects.equals(this.readConcern, transactionOptions.readConcern)) {
            return false;
        }
        if (!Objects.equals(this.writeConcern, transactionOptions.writeConcern)) {
            return false;
        }
        return Objects.equals(this.readPreference, transactionOptions.readPreference);
    }

    public int hashCode() {
        int n = this.readConcern != null ? this.readConcern.hashCode() : 0;
        n = 31 * n + (this.writeConcern != null ? this.writeConcern.hashCode() : 0);
        n = 31 * n + (this.readPreference != null ? this.readPreference.hashCode() : 0);
        n = 31 * n + (this.maxCommitTimeMS != null ? this.maxCommitTimeMS.hashCode() : 0);
        n = 31 * n + (this.timeoutMS != null ? this.timeoutMS.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "TransactionOptions{readConcern=" + this.readConcern + ", writeConcern=" + this.writeConcern + ", readPreference=" + this.readPreference + ", maxCommitTimeMS=" + this.maxCommitTimeMS + ", timeoutMS=" + this.timeoutMS + '}';
    }

    private TransactionOptions(Builder builder) {
        this.readConcern = builder.readConcern;
        this.writeConcern = builder.writeConcern;
        this.readPreference = builder.readPreference;
        this.maxCommitTimeMS = builder.maxCommitTimeMS;
        this.timeoutMS = builder.timeoutMS;
    }

    public static final class Builder {
        private ReadConcern readConcern;
        private WriteConcern writeConcern;
        private ReadPreference readPreference;
        private Long maxCommitTimeMS;
        @Nullable
        private Long timeoutMS;

        public Builder readConcern(@Nullable ReadConcern readConcern) {
            this.readConcern = readConcern;
            return this;
        }

        public Builder writeConcern(@Nullable WriteConcern writeConcern) {
            this.writeConcern = writeConcern;
            return this;
        }

        public Builder readPreference(@Nullable ReadPreference readPreference) {
            this.readPreference = readPreference;
            return this;
        }

        public Builder maxCommitTime(@Nullable Long l, TimeUnit timeUnit) {
            if (l == null) {
                this.maxCommitTimeMS = null;
            } else {
                Assertions.notNull("timeUnit", timeUnit);
                Assertions.isTrueArgument("maxCommitTime > 0", l > 0L);
                this.maxCommitTimeMS = TimeUnit.MILLISECONDS.convert(l, timeUnit);
            }
            return this;
        }

        @Alpha(value={Reason.CLIENT})
        public Builder timeout(@Nullable Long l, TimeUnit timeUnit) {
            this.timeoutMS = TimeoutSettings.convertAndValidateTimeoutNullable(l, timeUnit);
            return this;
        }

        public TransactionOptions build() {
            return new TransactionOptions(this);
        }

        private Builder() {
        }
    }
}

