/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;

@Immutable
public class WriteConcern
implements Serializable {
    private static final long serialVersionUID = 1884671104750417011L;
    private static final Map<String, WriteConcern> NAMED_CONCERNS;
    private final Object w;
    private final Integer wTimeoutMS;
    private final Boolean journal;
    public static final WriteConcern ACKNOWLEDGED;
    public static final WriteConcern W1;
    public static final WriteConcern W2;
    public static final WriteConcern W3;
    public static final WriteConcern UNACKNOWLEDGED;
    public static final WriteConcern JOURNALED;
    public static final WriteConcern MAJORITY;

    public WriteConcern(int n) {
        this(n, null, null);
    }

    public WriteConcern(String string) {
        this(string, null, null);
        Assertions.notNull("w", string);
    }

    public WriteConcern(int n, int n2) {
        this(n, n2, null);
    }

    private WriteConcern(@Nullable Object object, @Nullable Integer n, @Nullable Boolean bl) {
        if (object instanceof Integer) {
            Assertions.isTrueArgument("w >= 0", (Integer)object >= 0);
            if ((Integer)object == 0) {
                Assertions.isTrueArgument("journal is false when w is 0", bl == null || bl == false);
            }
        } else if (object != null) {
            Assertions.isTrueArgument("w must be String or int", object instanceof String);
        }
        Assertions.isTrueArgument("wtimeout >= 0", n == null || n >= 0);
        this.w = object;
        this.wTimeoutMS = n;
        this.journal = bl;
    }

    @Nullable
    public Object getWObject() {
        return this.w;
    }

    public int getW() {
        Assertions.isTrue("w is an Integer", this.w != null && this.w instanceof Integer);
        return (Integer)this.w;
    }

    public String getWString() {
        Assertions.isTrue("w is a String", this.w != null && this.w instanceof String);
        return (String)this.w;
    }

    @Nullable
    public Integer getWTimeout(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return this.wTimeoutMS == null ? null : Integer.valueOf((int)timeUnit.convert(this.wTimeoutMS.intValue(), TimeUnit.MILLISECONDS));
    }

    @Nullable
    public Boolean getJournal() {
        return this.journal;
    }

    public boolean isServerDefault() {
        return this.equals(ACKNOWLEDGED);
    }

    public BsonDocument asDocument() {
        BsonDocument bsonDocument = new BsonDocument();
        this.addW(bsonDocument);
        this.addWTimeout(bsonDocument);
        this.addJ(bsonDocument);
        return bsonDocument;
    }

    public boolean isAcknowledged() {
        if (this.w instanceof Integer) {
            return (Integer)this.w > 0 || this.journal != null && this.journal != false;
        }
        return true;
    }

    public static WriteConcern valueOf(String string) {
        return NAMED_CONCERNS.get(string.toLowerCase());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WriteConcern writeConcern = (WriteConcern)object;
        if (!Objects.equals(this.w, writeConcern.w)) {
            return false;
        }
        if (!Objects.equals(this.wTimeoutMS, writeConcern.wTimeoutMS)) {
            return false;
        }
        return Objects.equals(this.journal, writeConcern.journal);
    }

    public int hashCode() {
        int n = this.w != null ? this.w.hashCode() : 0;
        n = 31 * n + (this.wTimeoutMS != null ? this.wTimeoutMS.hashCode() : 0);
        n = 31 * n + (this.journal != null ? this.journal.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "WriteConcern{w=" + this.w + ", wTimeout=" + this.wTimeoutMS + " ms, journal=" + this.journal + "}";
    }

    public WriteConcern withW(int n) {
        return new WriteConcern(n, this.wTimeoutMS, this.journal);
    }

    public WriteConcern withW(String string) {
        Assertions.notNull("w", string);
        return new WriteConcern(string, this.wTimeoutMS, this.journal);
    }

    public WriteConcern withJournal(@Nullable Boolean bl) {
        return new WriteConcern(this.w, this.wTimeoutMS, bl);
    }

    public WriteConcern withWTimeout(long l, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        long l2 = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        Assertions.isTrueArgument("wTimeout >= 0", l >= 0L);
        Assertions.isTrueArgument("wTimeout <= 2147483647 ms", l2 <= Integer.MAX_VALUE);
        return new WriteConcern(this.w, (int)l2, this.journal);
    }

    private void addW(BsonDocument bsonDocument) {
        if (this.w instanceof String) {
            bsonDocument.put("w", new BsonString((String)this.w));
        } else if (this.w instanceof Integer) {
            bsonDocument.put("w", new BsonInt32((Integer)this.w));
        }
    }

    private void addJ(BsonDocument bsonDocument) {
        if (this.journal != null) {
            bsonDocument.put("j", BsonBoolean.valueOf(this.journal));
        }
    }

    private void addWTimeout(BsonDocument bsonDocument) {
        if (this.wTimeoutMS != null) {
            bsonDocument.put("wtimeout", new BsonInt32(this.wTimeoutMS));
        }
    }

    static {
        ACKNOWLEDGED = new WriteConcern(null, null, null);
        W1 = new WriteConcern(1);
        W2 = new WriteConcern(2);
        W3 = new WriteConcern(3);
        UNACKNOWLEDGED = new WriteConcern(0);
        JOURNALED = ACKNOWLEDGED.withJournal(true);
        MAJORITY = new WriteConcern("majority");
        NAMED_CONCERNS = new HashMap<String, WriteConcern>();
        for (Field field : WriteConcern.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(WriteConcern.class)) continue;
            String string = field.getName().toLowerCase();
            try {
                NAMED_CONCERNS.put(string, (WriteConcern)field.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
    }
}

