/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoServerException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcernResult;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;

public class WriteConcernException
extends MongoServerException {
    private static final long serialVersionUID = -1100801000476719450L;
    private final WriteConcernResult writeConcernResult;
    private final BsonDocument response;

    public WriteConcernException(BsonDocument bsonDocument, ServerAddress serverAddress, WriteConcernResult writeConcernResult) {
        super(WriteConcernException.extractErrorCode(bsonDocument), String.format("Write failed with error code %d and error message '%s'", WriteConcernException.extractErrorCode(bsonDocument), WriteConcernException.extractErrorMessage(bsonDocument)), serverAddress);
        this.response = bsonDocument;
        this.writeConcernResult = writeConcernResult;
    }

    public static int extractErrorCode(BsonDocument bsonDocument) {
        String string = WriteConcernException.extractErrorMessage(bsonDocument);
        if (string != null) {
            if (bsonDocument.containsKey("err") && string.contains("E11000 duplicate key error")) {
                return 11000;
            }
            if (!bsonDocument.containsKey("code") && bsonDocument.containsKey("errObjects")) {
                for (BsonValue bsonValue : bsonDocument.getArray("errObjects")) {
                    if (!string.equals(WriteConcernException.extractErrorMessage(bsonValue.asDocument()))) continue;
                    return bsonValue.asDocument().getNumber("code").intValue();
                }
            }
        }
        return bsonDocument.getNumber("code", new BsonInt32(-1)).intValue();
    }

    @Nullable
    public static String extractErrorMessage(BsonDocument bsonDocument) {
        if (bsonDocument.isString("err")) {
            return bsonDocument.getString("err").getValue();
        }
        if (bsonDocument.isString("errmsg")) {
            return bsonDocument.getString("errmsg").getValue();
        }
        return null;
    }

    public WriteConcernResult getWriteConcernResult() {
        return this.writeConcernResult;
    }

    public int getErrorCode() {
        return WriteConcernException.extractErrorCode(this.response);
    }

    @Nullable
    public String getErrorMessage() {
        return WriteConcernException.extractErrorMessage(this.response);
    }

    public BsonDocument getResponse() {
        return this.response;
    }
}

