/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.lang.Nullable;
import org.bson.BsonValue;

public abstract class WriteConcernResult {
    public abstract boolean wasAcknowledged();

    public abstract int getCount();

    public abstract boolean isUpdateOfExisting();

    @Nullable
    public abstract BsonValue getUpsertedId();

    public static WriteConcernResult acknowledged(final int n, final boolean bl, final @Nullable BsonValue bsonValue) {
        return new WriteConcernResult(){

            @Override
            public boolean wasAcknowledged() {
                return true;
            }

            @Override
            public int getCount() {
                return n;
            }

            @Override
            public boolean isUpdateOfExisting() {
                return bl;
            }

            @Override
            @Nullable
            public BsonValue getUpsertedId() {
                return bsonValue;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                WriteConcernResult writeConcernResult = (WriteConcernResult)object;
                if (!writeConcernResult.wasAcknowledged()) {
                    return false;
                }
                if (n != writeConcernResult.getCount()) {
                    return false;
                }
                if (bl != writeConcernResult.isUpdateOfExisting()) {
                    return false;
                }
                return !(bsonValue != null ? !bsonValue.equals(writeConcernResult.getUpsertedId()) : writeConcernResult.getUpsertedId() != null);
            }

            public int hashCode() {
                int n2 = n;
                n2 = 31 * n2 + (bl ? 1 : 0);
                n2 = 31 * n2 + (bsonValue != null ? bsonValue.hashCode() : 0);
                return n2;
            }

            public String toString() {
                return "AcknowledgedWriteResult{count=" + n + ", isUpdateOfExisting=" + bl + ", upsertedId=" + bsonValue + '}';
            }
        };
    }

    public static WriteConcernResult unacknowledged() {
        return new WriteConcernResult(){

            @Override
            public boolean wasAcknowledged() {
                return false;
            }

            @Override
            public int getCount() {
                throw this.getUnacknowledgedWriteException();
            }

            @Override
            public boolean isUpdateOfExisting() {
                throw this.getUnacknowledgedWriteException();
            }

            @Override
            public BsonValue getUpsertedId() {
                throw this.getUnacknowledgedWriteException();
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                WriteConcernResult writeConcernResult = (WriteConcernResult)object;
                return !writeConcernResult.wasAcknowledged();
            }

            public int hashCode() {
                return 1;
            }

            public String toString() {
                return "UnacknowledgedWriteResult{}";
            }

            private UnsupportedOperationException getUnacknowledgedWriteException() {
                return new UnsupportedOperationException("Cannot get information about an unacknowledged write");
            }
        };
    }
}

